#include "TransferCommand.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"
#include "Sct/IOName.h"
#include "Archiver.h"

using namespace boost;

namespace SctArchiving{

  TransferCommand::TransferCommand(boost::shared_ptr<GetCommand> get, 
				   boost::shared_ptr<PutCommand> put) 
    :  m_get(get), m_put(put) 
  {}

  TransferCommand::~TransferCommand() {}

  TransferCommand::TransferCommand() {}

  void TransferCommand::execute(){
    if ( m_get->getIOName().wildcard() ) {
      std::cout << "Expanding " << m_get->getIOName().getIOName()  <<" in process " << getpid() <<  std::endl;
      // name is a wildcard:
      for (Sct::IOName::const_iterator i = m_get->getIOName().begin(); 
	   i!=m_get->getIOName().end(); ++i){

	shared_ptr<TransferCommand> newcmd = dynamic_pointer_cast<TransferCommand> (create());
	if (!newcmd.get()) throw Sct::IllegalStateError("Bad cast", __FILE__, __LINE__);
	newcmd = dynamic_pointer_cast<TransferCommand> (this->create());
	newcmd->m_get->setName(*i);
	//newcmd->execute();
	Archiver::instance().addCommand(newcmd);
      }
    }else{
      // single command:
      
      //std::cout << Archiver::instance().getStatus() << std::endl;
      std::cout << "Executing transfer of " << m_get->getIOName().getIOName() <<" in process " << getpid() <<  std::endl;
      m_get->execute();
      shared_ptr<Sct::Serializable> ob = m_get->getObject();
      if (!ob.get()) {
	string message = "Get was unsuccessful : "; 
	message+=m_get->getIOName().getIOName();
	throw Sct::IoException(message, __FILE__, __LINE__);
      }
      
      // put it:
      m_put->set(ob);
      m_put->execute();
    }
  }

  shared_ptr<ArchivingCommand> TransferCommand::create() const {
    shared_ptr<GetCommand> newget = dynamic_pointer_cast<GetCommand>(m_get->create());
    shared_ptr<PutCommand> newput = dynamic_pointer_cast<PutCommand>(m_put->create());
    newput->setParams(m_put->getParams());
    return shared_ptr<TransferCommand>(new TransferCommand(newget, newput));
  }

}
