
/**
   Makes persistent representation of SctData objects,
   and control data objects so that they can be retrieved at a later date.
   The SctData::TestResult and SctData::ScanResult classes are subscribed to
   (e.g. fits and raw data), as well as the ControlData objects e.g. TestData
   and SequenceData which are really an index of modules in a particular test.

   The interface is via ipc. There is automatic saving by callback to some IS 
   servers (currently EventData and RetrievedData, TestData and ControlData).
   Other objects can be saved by IPC request.

   Retrieval is via IPC requests, where wildcards can be used to request
   many objects matching a particular pattern.

    Examples of commands which work are :

<P> retrieve("1010","2","SctData::RawScanResult","20220170100038")
<BR> RawScanResult for run 1010, scan 2, for module 20220170100038
<P> retrieve("1010","*","SctData::RawScanResult","*")
<BR> all RawScanResults from run 1010
<P> retrieve("1009","5","SctData::StrobeDelayTestResult","*")
<BR> StrobeDelayTestResult for run 1009, scan 5, all modules
<P> retrieve("1009","5","SctData::StrobeDelayTestResult","202201*")
<BR> same but just for modules starting 202201
<P> retrieve("1013","0","TestData","StrobeDelayTest")
<BR> StrobeDelay TestData object for run 1013
  
   These commands retrieve the object from persistant storage back into
   IS - the default server is RetrievedData, but this can be changed over IPC.

   The Sct::IOManager derrives from Sct::IOManagerStreamerVersioned, 
   when means that 
   as well as writing the name of the class it is streaming, it also 
   writes the version. Historic versions of the streamers are kept in 
   the SctData/src/IO directory, and are added to the streamer map,
   so that old data can continue to be read, even after thte data definition
   changes.
   
   The current implimentation is via a gzipped file 
   (Sct::Archive::IOManagerArchiveFile) 
   to the $SCT_PERSISTENT_DIR directory. 
   It is hoped that by release 4 of this software
   the persistant storage will be in the ATLAS conditions database.

   See ArchivingServiceInterface.idl for full interface.
   
Subtleties:
   If retrieving to an IS server which normally has a callback, one
   should suspend the callbacks, otherwise it will try to be saved again.
   
   The name of the retrieval IS server can be changed, but note that the 
   retrieve command is asynchronous - so there may still be a queue of objects
   waiting to be retrieved to the previous server. One can check the previous
   operations have finished using the busy() method.

   @author Alan Barr
   @date 10 Feb 2004
 */
namespace SctArchiving{
}
