//#include "Sct/isstream_bugfix.h"
#include "ArchivingWorkerGroup.h"
#include "ArchivingCommand.h"
#include "Sct/StdExceptionWrapper.h"

namespace SctArchiving {

void ArchivingWorkerGroup::work(shared_ptr<ArchivingCommand> command) throw() {
  try {
    if (!command.get()) throw Sct::IllegalStateError("null command", __FILE__, __LINE__);
    command->execute();
  } catch(Sct::Throwable& e) {
    e.sendToMrs(MRS_ERROR);
  } catch(std::exception& e) {
    Sct::StdExceptionWrapper sew(e);
    sew.sendToMrs(MRS_ERROR);
  } catch(...) {
    Sct::Error e("uncaught unknown exception", __FILE__, __LINE__);
    e.sendToMrs(MRS_ERROR);
  }
}


}// end of namespace SctArchiving
