#ifndef SCTARCHIVING_ARCHIVEGETCOMMAND_H
#define  SCTARCHIVING_ARCHIVEGETCOMMAND_H
#include "GetCommand.h"
#include "Sct/Serializable.h"
#include "Sct/Archive/IONameArchiveFile.h"

namespace SctArchiving{
  /** GetCommand to get an object from the archive,
   * using the Sct::Archive::IOManagerArchive kept by the Archiver::instance() */
  class ArchiveGetCommand : public GetCommand {
  public:
    /** Gets IOName from archive */
    ArchiveGetCommand(boost::shared_ptr<Sct::Archive::IONameArchiveFile> name);
    /** destructor */
    ~ArchiveGetCommand();
    /** gets the object from the archive */
    virtual void execute();
    /** impliment */
    virtual boost::shared_ptr<ArchivingCommand> create() const; 
  protected:
    ArchiveGetCommand();
  };
}
#endif
