#ifndef TIMEWALKALGORITHM_H
#define TIMEWALKALGORITHM_H

#include "AnalysisAlgorithm.h"

namespace SctAnalysis {
    /**
       Algorithm for TimeWalk Test.
    */
class TimeWalkAlgorithm : public AnalysisAlgorithm {
public:
    virtual bool canAnalyze() const;
    virtual void analyze();
    virtual void loadData();
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
    /** 
	constructor 
     */
    TimeWalkAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~TimeWalkAlgorithm() throw() {}
    
private:
    TimeWalkAlgorithm() {}
    static bool inMap;
};
}

#endif //TIMEWALKALGORITHM_H
