#ifndef RXTHRESHOLDALGORITHM_H
#define RXTHRESHOLDALGORITHM_H
#include "AnalysisAlgorithm.h"

namespace SctData {
    class RxThresholdTestResult;
    class FitScanResult;
}

namespace SctAnalysis {
    /**
     * Algorithm for finding best Rx Threshold.
     * Find the region for which the average occupancy is
     * between 0.25 and 0.75.
     * Take the mid-point of this region.
    */
class RxThresholdAlgorithm : public AnalysisAlgorithm {
public:        
    /** 
	finds the optimum - a fractions of the way from the mid-rise to the mid-fall of the 
	function.
     */
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();    
    /** 
	constructor 
     */
    RxThresholdAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~RxThresholdAlgorithm() throw() {}
private:
    RxThresholdAlgorithm() {}
    static bool inMap;    
};
}
#endif //#ifndef RXTHRESHOLDALGORITHM_H
