#ifndef NOISEOCCUPANCYALGORITHM_H
#define NOISEOCCUPANCYALGORITHM_H

#include "AnalysisAlgorithm.h"

class TF1;

namespace SctData {
    class ChipNOResult;
    class NoiseOccupancyTestResult;
    class ChipConfiguration;
    class OccupancyProjector;
    class DefectList;
}

namespace SctAnalysis {
    
class NoiseOccupancyAlgorithm : public AnalysisAlgorithm {
public:
    /** 
	constructor 
     */
    NoiseOccupancyAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~NoiseOccupancyAlgorithm() throw();
    
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
    
    /** 
     * given the occupancy projector and response curve, produces result for a chip.
     * @note Nothrow
     */
    SctData::ChipNOResult analyzeChip(const unsigned ichip, const SctData::OccupancyProjector&, const SctData::ChipConfiguration&, SctData::DefectList& defects) ;
private:
    NoiseOccupancyAlgorithm() {}
    unsigned short m_scanVariable; ///< pointer to variable type.
    static bool inMap;
};
}
#endif //#ifndef NOISEOCCUPANCYALGORITHM_H
