#ifndef SCTANALYSIS_NMASKALGORITHM_H
#define SCTANALYSIS_NMASKALGORITHM_H

#include "AnalysisAlgorithm.h"

namespace SctAnalysis {
    
/**
   Algorithm for single-scan NMask Test.
   Uses a single RawScanResult to find defects in the pipeline.
*/
class NMaskAlgorithm : public AnalysisAlgorithm {
public:
    virtual void analyze();
    virtual void loadData();
    virtual bool canAnalyze() const;
    virtual shared_ptr<SctData::TestResult> createTestResult() const;
    virtual boost::shared_ptr<AnalysisAlgorithm> clone(const TestData& testData, const string& moduleName) const throw();
    /**
	constructor 
     */
    NMaskAlgorithm(const TestData& testData, const string& moduleName, const AnalysisAlgorithm& alg) throw() : AnalysisAlgorithm(testData, moduleName, alg) {}
    /** 
	destructor 
     */
    virtual ~NMaskAlgorithm() throw() {}
private:
    NMaskAlgorithm() {}
    static bool inMap;
};
}

#endif //SCTANALYSIS_NMASKALGORITHM_H
