package guiUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.*;
import javax.swing.table.AbstractTableModel;
import Preferences.*;

/**
 *
 * @author  robinson
 */
public class SpreadsheetViewer extends javax.swing.JFrame implements ListSelectionListener {
    private static SpreadsheetViewer instance = new SpreadsheetViewer();
    int selectedRow;
    ListSelectionModel rowSM;
    myTableAdapter db;
    /** Creates new form JFrame */

    public SpreadsheetViewer() {
        super("Spreadsheet Viewer");
        db = new myTableAdapter();
        selectedRow=-1;
        initComponents();
    }

    public static SpreadsheetViewer getInstance() {
        return instance;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        scrollPane = new javax.swing.JScrollPane();
        saveButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        titleLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        table = new JTable(db);
//        table.setPreferredScrollableViewportSize(new java.awt.Dimension(800, 150));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setFont(new java.awt.Font("Arial",java.awt.Font.PLAIN,10));
        rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(this);
        scrollPane = new JScrollPane(table);
        scrollPane.setMaximumSize(new java.awt.Dimension(900, 800));
        scrollPane.setMinimumSize(new java.awt.Dimension(800, 150));
        scrollPane.setPreferredSize(new java.awt.Dimension(800, 150));
        scrollPane.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.85;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        getContentPane().add(scrollPane, gridBagConstraints);

        saveButton.setText("Save spreadsheet");
        saveButton.setFont(new java.awt.Font("Arial",java.awt.Font.PLAIN,10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(saveButton, gridBagConstraints);
        saveButton.setEnabled(false);
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
        
	     JFileChooser fc;
	     fc = new JFileChooser(PreferencesInterface.getInstance().getPreference(PreferencesInterface.SCRATCH_DIR));

	     int returnVal = fc.showSaveDialog(null);
	     if (returnVal != JFileChooser.APPROVE_OPTION) return;

	     java.io.File file = fc.getSelectedFile();
             db.writeTXT(file); 

            }
        });

        closeButton.setText("Close");
        closeButton.setFont(new java.awt.Font("Arial",java.awt.Font.PLAIN,10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        getContentPane().add(closeButton, gridBagConstraints);
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              setVisible(false);
            }
        });


        titleLabel.setText("title");
        titleLabel.setFont(new java.awt.Font("Arial",java.awt.Font.PLAIN,10));
        titleLabel.setForeground(new java.awt.Color(51, 0, 153));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.05;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(titleLabel, gridBagConstraints);

        pack();
    }
    
//	public java.awt.Insets getInsets() {
//		return new java.awt.Insets(10,10,10,10);
//		}

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        setVisible(false);
    }
    

     public void valueChanged(ListSelectionEvent e) {
          selectedRow=-1;
          if(e.getValueIsAdjusting()) return;
          ListSelectionModel lsm = (ListSelectionModel)e.getSource();
          if(lsm.isSelectionEmpty()) {

            }
          else {
             selectedRow = lsm.getMinSelectionIndex();

             }
          }

   public void update(String text, java.util.Vector theData) {
     titleLabel.setText(text);
     db.reTable(theData);
     if(db.recordCount>0) {
           saveButton.setEnabled(true);
         } else {
           saveButton.setEnabled(false);
	 }
      show();
     }
   public int getSelectedRow() {
      return rowSM.getMinSelectionIndex();
      }


    
    
    // Variables declaration - do not modify
    private javax.swing.JButton saveButton;
    private javax.swing.JButton closeButton;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JTable table;
    // End of variables declaration


    
}
