package SummaryReader;
import java.util.regex.*;
public interface regExpressions {

    static final Pattern testregex = Pattern.compile("(%LongTermTest|%RedundancyTest|%HardReset|%PipelineTest|%FullBypassTest|%StrobeDelay|%ResponseCurve|%ThreePointGain|%NO|%Trim|%TimeWalkTest|%DetModIV|%ModIVScan|%NMaskTest|%RxDelay|%RxThreshold)");

    static final String[] chipNames = {"^#M0$","^#S1$","^#S2$","^#S3$","^#S4$","^#E5$","^#M8$","^#S9$","^#S10$","^#S11$","^#S12$","^#E13$"};
    static final String[] fullBypassChipPattern = {"#M0\\s+S1$","#S2\\s+S3$","#S4\\s+E5$","#M8\\s+S9$","#S10\\s+S11$","#S12\\s+E13$"};
    static final Pattern runPattern = Pattern.compile("Run number\\s*:\\s*(.*)",Pattern.CASE_INSENSITIVE);
    static final Pattern serialNoPattern = Pattern.compile("SERIAL NUMBER\\s*:\\s*(\\d{14}|CRATE\\d{2}CHAN\\d{2}).*");
    static final Pattern snPattern = Pattern.compile("(\\d{14})");
    static final Pattern testDatePattern = Pattern.compile("TEST_DATE\\s*:\\s*([\\d/]+)");
    static final Pattern passedPattern = Pattern.compile("PASSED\\s*:\\s*([\\w]+)");
    static final Pattern problemPattern = Pattern.compile("PROBLEM\\s*:\\s*([\\w]+)");
    static final Pattern scanNoPattern = Pattern.compile("(\\d+)-(\\d+)");
    static final Pattern runScanPattern = Pattern.compile("Run number\\s*:\\s*(\\d+)-(\\d+)");
    static final Pattern ivDataPattern = Pattern.compile("IVDATA:(.*):(.*)");

    static final Pattern iv150Pattern = Pattern.compile("^I\\s+LEAK\\s+150\\s*:\\s*(.*)");
    static final Pattern iv350Pattern = Pattern.compile("^I\\s+LEAK\\s+350\\s*:\\s*(.*)");
    static final Pattern iv500Pattern = Pattern.compile("^#I\\s+LEAK\\s+500\\s*:\\s*(.*)");
    static final Pattern temperaturePattern = Pattern.compile("^TEMPERATURE\\s*:\\s*(.*)");

    static final Pattern nDefectsPattern = Pattern.compile("#(\\d+) defects found");

    static final Pattern spacerPattern = Pattern.compile("^\\s+(.*)$");

    static final Pattern defectSummaryPattern = Pattern.compile("^#(\\d+) defects found affecting (\\d+) strips$");
    static final Pattern defectNamePattern = Pattern.compile("^DEFECT NAME\\s*:\\s*(.*)");
    static final Pattern defectNameDefect0 = Pattern.compile("^FIRST CHANNEL\\s*:\\s*(.*)");
    static final Pattern defectNameDefect1 = Pattern.compile("^LAST CHANNEL\\s*:\\s*(.*)");

    static final Pattern commentsPattern = Pattern.compile("^COMMENT\\s*:\\s*(.*)");

    static final Pattern filenamePattern = Pattern.compile("^FILENAME\\s*:\\s*(.*)");

    static final String[] chips = {"M0","S1","S2","S3","S4","E5","M8","S9","S10","S11","S12","E13"};

}

