package SummaryReader;

public class DataBlock implements regExpressions, DisplayGUI.TestDataInfo {

    Double[][] data = new Double[12][];
    String title;
    String[] headers;
    Double[][] means = new Double[4][];
    int arraySize;
    int testType;

    java.text.DecimalFormat nf = new java.text.DecimalFormat("#.##");
    java.text.DecimalFormat nfe = new java.text.DecimalFormat("#.##E0");

    public DataBlock(String title, int arraySize, int testType) {
       this.title=title;
       this.testType=testType;
       this.arraySize=arraySize;
       for(int i=0;i<12;i++) data[i] = new Double[arraySize];
       for(int i=0;i<4;i++) means[i] = new Double[arraySize]; 
       headers = new String[arraySize];
       }
    public void add(int chip, int column, String dataString) {
       try {
         data[chip][column]=Double.valueOf(dataString);
         }catch(Exception parseException){
              dataString = dataString.toLowerCase(); // handle the strings in FullByPass test
              if(dataString.equals("not tested")) data[chip][column] = new Double(0.);
              else if(dataString.equals("minimal tested")) data[chip][column] = new Double(1.);
              else {
                data[chip][column]=null; 
                System.err.println("Failed to parse datas for chip,parameter: "+chip+","+column+" : "+dataString);
                }
              }
       }
    public void add(int chip, int column, double theData) {
       try {
         data[chip][column]=new Double(theData);
         }catch(Exception parseException){data[chip][column]=null; System.err.println("Failed to parse datas for chip,parameter: "+chip+","+column+" : "+theData);}
       }
    
    public void add(int param, String header) {
       headers[param]=header;
       }
    public String getTitle() {
       return title;
       }
    public void calculateMeans() {
       double refValue;
       for(int column=0;column<arraySize;column++) {
         double maxValue=-99999.;
         double minValue=99999.;
         double mean0=0.;
         double mean1=0.;
         for(int i=0;i<12;i++) {
             if(data[i][column]==null) {
                System.err.println("Null data for chip,column "+i+","+column+" for "+title);
                continue;
                }
             double thisValue = data[i][column].doubleValue();
//             if(thisValue==0. && !canBeZero[testType][column+3]) continue;
             if(i<6) mean0+=thisValue;
             else mean1+=thisValue;
             if(thisValue>maxValue) maxValue=thisValue;
             if(thisValue<minValue) minValue=thisValue;
             }
        means[0][column] = new Double(maxValue);
        means[1][column] = new Double(minValue);
        double d = mean0/6.;
        if(d<0.001) means[2][column] = Double.valueOf(nfe.format(d));
        else means[2][column] = Double.valueOf(nf.format(d));
        d=mean1/6.;
        if(d<0.001) means[3][column] = Double.valueOf(nfe.format(d));
        else means[3][column] = Double.valueOf(nf.format(d));
        }
      }
       
    public Double get(int chip, int column) {
       if(chip<4) {
            double value = means[chip][column].doubleValue();
            if(value==0. && !canBeZero[testType][column+3]) return null;
            if(value==-99999. || value==99999.) return null;
            return means[chip][column];
            }
       if(data[chip-4][column]==null) return null;
       if(data[chip-4][column].doubleValue()==0. && !canBeZero[testType][column+3]) return null;
       else return data[chip-4][column];        
       }
    public String getSummaryTable() {
       StringBuffer table = new StringBuffer("<h3>"+title+"</h3>\n");
       table.append("<table border=1>\n");
       table.append("<tr><td>Chip</td>");
       for(int param=0;param<headers.length;param++) table.append("<td>"+headers[param]+"</td>");
       table.append("</tr>");
       for(int chip=0;chip<12;chip++) {
          table.append("<tr><td>"+chips[chip]+"</td>");
          for(int param=0;param<data[chip].length;param++) {
             if(data[chip][param]!=null) table.append("<td>"+data[chip][param].toString()+"</td>");
             }
          table.append("</tr>");
          }
       table.append("</table>\n");
       return table.toString();
       }       
}