package ProdDatabase;
import java.util.regex.*;
import java.io.*;
public class UploaderTask {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean cancelled = false;
    private String statMessage;
    private String command;
    private boolean quitOnFinish;

    public UploaderTask(int noOfModules, String cmd, boolean quitOnFinish) {
        lengthOfTask = noOfModules;
        command = cmd;
        this.quitOnFinish = quitOnFinish;
    }

    /**
     * Called from ProgressBarDemo to start the task.
     */
    public void go() {
        final guiUtilities.SwingWorker worker = new guiUtilities.SwingWorker() {
            public Object construct() {
                current = 0;
                done = false;
                cancelled = false;
                statMessage = null;
                return new ActualTask();
            }
        };
        worker.start();
    }

    /**
     * to be done.
     */
    public int getLengthOfTask() {
        return lengthOfTask;
    }

    /**
     */
    public int getCurrent() {
        return current;
    }

    public void stop() {
        cancelled = true;
        statMessage = null;
    }

    /**
     * Called from ProgressBarDemo to find out if the task has completed.
     */
    public boolean isDone() {
        return done;
    }

    /**
     * Returns the most recent status message, or null
     * if there is no current status message.
     */
    public String getMessage() {
        return statMessage;
    }

    /**
     * The actual long running task.  This runs in a SwingWorker thread.
     */
    class ActualTask {
        Pattern d14Pattern = Pattern.compile(".*(\\d{14}).*");
        ActualTask() {
	  Process p = null;
 	   try {

                String OS = System.getProperty("os.name").toLowerCase();
		if (OS.indexOf("linux") >= 0) {
		    String [] cmds = {"/bin/sh","-c",command};
		   p = Runtime.getRuntime().exec( cmds );
		} else {
		   p = Runtime.getRuntime().exec( command );
		}

//		p.waitFor();

		BufferedReader in = new BufferedReader( new InputStreamReader( p.getInputStream() ) );

		String t = in.readLine();
                if(t!=null) System.out.println(t);

		while( !cancelled && t!=null && current<lengthOfTask )
		   {
  			t = in.readLine();
                        if(t!=null) {
                          System.out.println(t);
                          Matcher matcher = d14Pattern.matcher(t);
                          if(matcher.matches()) statMessage = t.substring(matcher.start(1),matcher.end(1));
                          if(t.indexOf("DB transaction commited.")!=-1) current++;
                          }
		    }
		in.close();
                if(cancelled && p!=null) p.destroy();
                done=true;

	        } catch(Exception rcException) {System.out.println("SctGUI::UploaderTask error "+rcException.toString()); done=true;}
       if(cancelled) {
           String msg = "Upload Cancelled!\n You had uploaded "+current+" tests out of "+lengthOfTask;
           javax.swing.JOptionPane.showMessageDialog(null,msg);
           }
       else {
           String msg = "Upload Completed.\n You successfully uploaded "+current+" tests out of "+lengthOfTask;
           if(current<lengthOfTask) msg+="\nOne or more uploads appear to have failed. Please check the log files in your upload directory.";
           javax.swing.JOptionPane.showMessageDialog(null,msg);
           }
       if(quitOnFinish) System.exit(0);
       }
    }
}
