package ProdDatabase;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class UploadProgressMonitor  {
    public final static int ONE_SECOND = 1000;

    private ProgressMonitor progressMonitor;
    private Timer timer;
    private UploaderTask task;
    private String newline = "\n";
    private java.awt.Component guiControl;
    private boolean isInProgress=false;

    public UploadProgressMonitor(java.awt.Component parent) {
        guiControl=parent;

    }

    public void start(int noModules, String cmd, boolean quitOnFinish) {
        task = new UploaderTask(noModules,cmd,quitOnFinish);
        //Create a timer.
        timer = new Timer(ONE_SECOND, new TimerListener());

        // start the upload
        startUpload();
        }


    /**
     * The actionPerformed method in this class
     * is called each time the Timer "goes off".
     */
    class TimerListener implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            progressMonitor.setProgress(task.getCurrent());
            String s = task.getMessage();
            if (s != null) {
                progressMonitor.setNote(s);
            }
            if (progressMonitor.isCanceled() || task.isDone()) {
                progressMonitor.close();
                task.stop();
                Toolkit.getDefaultToolkit().beep();
                timer.stop();
                if (task.isDone()) System.out.println("Task completed.");
                else System.out.println("Task cancelled.");
                isInProgress=false;
                }
            }
        }

    /**
     * Called when the user presses the start button.
     */
    public void startUpload() {
        isInProgress=true;
        progressMonitor = new ProgressMonitor(guiControl,
                                  "Uploading to SCT Database",
                                  "", 0, task.getLengthOfTask());
        progressMonitor.setProgress(0);
        progressMonitor.setMillisToDecideToPopup(1 * ONE_SECOND);
        task.go();
        timer.start();
    }

    public boolean isBusy() {
       return isInProgress;
       }

}
