/*
 * PreferencesInterface.java
 *
 * 
 */

package Preferences;
import java.io.*;

/**
 *
 * @author  robinson
 */
public class PreferencesInterface {
    private static PreferencesInterface instance = new PreferencesInterface();
    File preferencesFile = new File(System.getProperty("user.home"),"SctGUI.prefs");
    private String[] keys = {"PREF_DEFAULT_VIEW%","PREF_INSTITUTE%","PREF_ZDIR%","PREF_UPLOADDIR%","PREF_PSVIEWER%","PREF_SCRATCHDIR%","PREF_DCS_SERVER%","PREF_AUTO_TEST_SELECT%","PREF_IVDIRECTORY%","PREF_LOOKUPTABLE_DIR%"};
    private String[] titles = {"Default SCT View","MacroAssemly Site Location","SCT Database Password","Database Upload Directory","Postscript file Viewer","Scratch Disk","DCS IS Server Name","Automatically select new test","IV Scan Data Directory","Web Lookup Table Directory"};
    private String[] values;
    public static final int SCT_VIEW=0;
    public static final int INSTITUTE=1;
    public static final int PASSWORD=2;
    public static final int UPLOAD_DIR=3;
    public static final int PSVIEWER=4;
    public static final int SCRATCH_DIR=5;
    public static final int DCS_SERVER_NAME=6;
    public static final int AUTO_TEST_SELECT=7;
    public static final int IV_DIRECTORY=8;
    public static final int WEB_LOOKUP_DIR=9;

    public static final String unDefinedString = "Not defined";
    
    /** Creates a new instance of SCTInterface */
    private PreferencesInterface() {
        Refresh();
    }
    
    public static PreferencesInterface getInstance() {
        return instance;
    }

    public void Refresh() {
       values = new String[keys.length];
       for(int i=0;i<values.length;i++) values[i]=new String(unDefinedString);
       readpreferencesFile();
       if(values[AUTO_TEST_SELECT].equals(unDefinedString)) setPreference(AUTO_TEST_SELECT,"TRUE"); 
       if(values[SCRATCH_DIR].equals(unDefinedString)) setPreference(SCRATCH_DIR,System.getProperty("user.home")); 
       if(values[UPLOAD_DIR].equals(unDefinedString)) setPreference(UPLOAD_DIR,System.getProperty("user.home")); 
       if(values[DCS_SERVER_NAME].equals(unDefinedString)) setPreference(DCS_SERVER_NAME,"IS_Server");
       String scratchDir;
       if((scratchDir = System.getProperty("Sct.Scratch.Dir", null))!=null) setPreference(SCRATCH_DIR,scratchDir);      
    }
    public String getPreference(int parameter) {
       return values[parameter];
       }
    public String getDescription(int parameter) {
        return titles[parameter];
        }
    public void setPreference(int parameter, String value) {
       values[parameter]=value;
       writepreferencesFile();
       }
   public int getNoPreferences() {
       return keys.length;
       }

   public File getPrefsFile() {
       return preferencesFile;
       }

    public void readpreferencesFile() {
       String line;
       
       try {
         if(!preferencesFile.exists()) return;
         BufferedReader in = new BufferedReader(new FileReader(preferencesFile));
         while((line=in.readLine())!=null) {
              for(int i=0;i<keys.length;i++) {
                   if(line.indexOf(keys[i])!=-1) {
                          values[i] = line.substring(keys[i].length());
                          break;
                          }
                   }
         }
         in.close();
        } catch(Exception e) {System.out.println("Failed to read Preferences file "+preferencesFile.toString()+" properly. It appears to be corrupted!.");};
     }

    public void writepreferencesFile() {
// if any config data has changed, save it to file.
// first save any nonPref data
           java.util.List nonPrefList = new java.util.ArrayList();
           File tempFile = new File(System.getProperty("user.home"),"temp.dat");
           try {
//************************
              if(preferencesFile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(preferencesFile));
                String line;
                while((line=in.readLine())!=null) {
                   if(!line.startsWith("PREF_")) nonPrefList.add(line);
                   }
                in.close();
              }
//*********************
              BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));
              String theNewLine;
              for(int i=0;i<keys.length;i++) {
               out.write(keys[i]+values[i]);
               out.newLine();
               }
              for(int i=0;i<nonPrefList.size();i++) {
                 out.write((String)nonPrefList.get(i));
                 out.newLine();
                 }
              out.close();
              boolean deleted = true;
              if(preferencesFile.exists()) deleted = preferencesFile.delete();
              if(deleted) {
                    tempFile.renameTo(preferencesFile);
                    if(preferencesFile.exists()) tempFile.delete();
                    else System.out.println("Preferences file lost!! Backup is at "+tempFile.toString());
                    }
           } catch (Exception e2) { System.out.println("Cant update preferences file");}; 
      }


}
