package DisplayGUI;
/*
 * ScalePointEditor.java
 *
 * Created on 03 February 2004, 09:51
 */

/**
 *
 * @author  robinson
 */
public class ScalePointEditor extends javax.swing.JDialog implements displayParams {
    ColorScalePoint scalePoint=null;
    ColorScalePoint originalScalePoint=null;
    boolean editValues;
    /** Creates new form ScalePointEditor */
    public ScalePointEditor(java.awt.Frame parent, boolean modal, ColorScalePoint scalePoint, boolean editValues) {
        super(parent, modal);
        this.editValues=editValues;
        if(scalePoint!=null) {
            this.scalePoint=scalePoint;
            originalScalePoint=scalePoint;
            }
        initComponents();
    }
    
    private void initComponents() {


        java.awt.GridBagConstraints gridBagConstraints;

        if(scalePoint!=null) jColorChooser1 = new javax.swing.JColorChooser(scalePoint.getColor());
        else jColorChooser1 = new javax.swing.JColorChooser();
        valueLabel = new javax.swing.JLabel();
        labellabel = new javax.swing.JLabel();
        title = new javax.swing.JLabel();
        valueField = new javax.swing.JTextField();
        labelField = new javax.swing.JTextField();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        getContentPane().add(jColorChooser1, gridBagConstraints);

        if(scalePoint==null) title.setText("Add a new Scale Point");
        else title.setText("Edit Scale Point");
        title.setForeground(darkBlueColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        getContentPane().add(title, gridBagConstraints);

        valueLabel.setText("Data Value:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(valueLabel, gridBagConstraints);

        labellabel.setText("Label (Optional):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(labellabel, gridBagConstraints);

        if(scalePoint!=null) valueField.setText(scalePoint.getValue().toString());
        else valueField.setText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        getContentPane().add(valueField, gridBagConstraints);

        if(scalePoint!=null) labelField.setText(scalePoint.getLabel());
        else labelField.setText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(labelField, gridBagConstraints);

        okButton.setText("Ok");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(okButton, gridBagConstraints);
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                Double value;
                Double labelValue;
                boolean labelIsNumber=true;
                try {
                   value = Double.valueOf(valueField.getText());
                }catch(Exception parseException) {
                   javax.swing.JOptionPane.showMessageDialog(null,"Value must be a number","Invalid value",javax.swing.JOptionPane.WARNING_MESSAGE);
                   return;
                   }
                try { // if label is number, make it the same as the value
                   labelValue=Double.valueOf(labelField.getText());
                }catch(Exception parseException2) {labelIsNumber=false;}
               String label = labelField.getText();
               if(label.equals("") || labelIsNumber) label = value.toString();
               scalePoint = new ColorScalePoint(value,jColorChooser1.getColor(),label);
               if(originalScalePoint!=null && scalePoint.equals(originalScalePoint)) scalePoint=null;
               closeDialog(null);
            }
        });

        cancelButton.setText("Cancel");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(cancelButton, gridBagConstraints);
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
               scalePoint=null;
               closeDialog(null);
            }
        });


        valueField.setEnabled(editValues);
        labelField.setEnabled(editValues);


        pack();
        show();
    }
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {
        setVisible(false);
        dispose();
    }
    public ColorScalePoint getColorScalePoint() {
        if(scalePoint.getColor()==null) return null;
        if(scalePoint.getColor().equals(java.awt.Color.white)) {
           javax.swing.JOptionPane.showMessageDialog(null,"White is a Reserved Colour\nbecause it denotes 'No Data' in most display modes.\nPlease choose a different colour.");
           return null;
           }
         return scalePoint;
        }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ScalePointEditor(new javax.swing.JFrame(), true, null, true).show();
    }
    
    
    // Variables declaration - do not modify
    private javax.swing.JButton cancelButton;
    private javax.swing.JColorChooser jColorChooser1;
    private javax.swing.JTextField labelField;
    private javax.swing.JLabel labellabel;
    private javax.swing.JLabel title;
    private javax.swing.JButton okButton;
    private javax.swing.JTextField valueField;
    private javax.swing.JLabel valueLabel;
    // End of variables declaration
    
}
