/*
 * ModuleCell.java
 *
 * Created on 18 June 2003, 13:57
 */

package DisplayGUI;
import java.awt.Polygon;

/**
 *
 * @author  robinson
 */
public class ModuleCell extends Polygon {
    
    
    private int MUR,modulePosition,sctComponent,row;
    private String serialNo;
    private int moduleGroup;
    private Double data;
    private java.awt.Color color;
//    boolean selected;
    
    /** Creates a new instance of sctComponentModuleCell */
    public ModuleCell(String serialNo, int sctComponent,  int row, int modulePosition,int MUR, int moduleGroup, int[] xPoints, int[] yPoints, int nPoints) {
        super(xPoints,yPoints,nPoints);
        this.serialNo=serialNo;
        this.modulePosition=modulePosition;
        this.MUR=MUR;
        this.sctComponent=sctComponent;
        this.row=row;
        this.moduleGroup=moduleGroup;
        data=null;
        color = java.awt.Color.white;
//        selected=false;
    }

//   public void setSelected(boolean selected) {
//        this.selected=selected;
//        }

    public void setData(Double value, java.awt.Color color) {
        this.data=value;
        this.color=color;
        }
    public Double getData() {
        return data;
        }
    public java.awt.Color getColor() {
        return color;
        }

    public String getSerialNo() {
        return serialNo;
    }
    public int getMUR() {
        return MUR;
    }
    public int getModulePosition() {
        return modulePosition;
    }
    public String getEndCapPosition() {
        if(modulePosition<13) return "O"+Integer.toString(modulePosition);
        else if(modulePosition>=13 && modulePosition<23) return "M"+Integer.toString(modulePosition-12);
        else return "I"+Integer.toString(modulePosition-22);
        }
    public void setModuleGroup(int group) {
        moduleGroup=group;
    }
    public int getModuleGroup() {
        return moduleGroup;
    }
    public boolean isSelected() {
        return (moduleGroup>=0);
    }
    public int getSctComponent() {
        return sctComponent;
        }
    public int getRow() {
        // this is the quadrant number for an endcap disk
        return row;
        }
    public String getQuadrant() {
        switch(row) {
           case 0:
              return "TR";
           case 1:
              return "BR";
           case 2:
              return "BL";
           case 3:
           default:
              return "TL";
           }
        }
    public int getPosition() {
        return modulePosition;
        }      
}
