/*
 * ExitPrompt.java
 *
 */

package DisplayGUI;
import java.util.*;
import GuiComponents.System.*;

/**
 *
 * @author  robinson
 */
public class ExitPrompt extends javax.swing.JDialog implements displayParams {
    private guiTableAdapter runTable;
    private javax.swing.JTable table;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox deleteAllRuns;
    private javax.swing.JCheckBox deleteSelectedRuns;
    private javax.swing.JLabel jLabel1,jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton okButton;
    private Hashtable runNumberHash;
    private boolean confirmExit=false;

    
    /** Creates new form ExitPrompt */
    public ExitPrompt(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        runNumberHash = new Hashtable();
        initComponents();
 //       checkArchiveService();
        fillTable();
//        this.setSize(500, 500);
    }
    
//    public String getText() {
//        return taInput.getText();
//    }
    public int getNoRuns() {
         return runTable.recordCount;
         }
    public boolean okToExit() {
        if(!confirmExit) return false;
        deleteDataFiles();
        return true;
        }
    

    private void initComponents() {

        getContentPane().setBackground(backgroundColor);

        runTable = new guiTableAdapter();
        table = new javax.swing.JTable(runTable);
        jScrollPane1 = new javax.swing.JScrollPane(table);
        table.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

        java.awt.GridBagConstraints gridBagConstraints;

//        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane(table);
        deleteSelectedRuns = new javax.swing.JCheckBox();
        deleteAllRuns = new javax.swing.JCheckBox();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setText("Quit SctGUI?");
        jLabel1.setFont(displayTitleFont);
        jLabel1.setForeground(darkBlueColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("Delete data files on exit?");
        jLabel2.setFont(displayScaleFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(jLabel2, gridBagConstraints);

        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        table.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane1.setMaximumSize(new java.awt.Dimension(300, 300));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(50, 50));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(200, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.6;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        deleteSelectedRuns.setText("Delete Selected Runs");
        deleteSelectedRuns.setFont(displayScaleFont);
        deleteSelectedRuns.setBackground(backgroundColor);
        deleteSelectedRuns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                if(deleteSelectedRuns.isSelected()) deleteAllRuns.setSelected(false);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(deleteSelectedRuns, gridBagConstraints);

        deleteAllRuns.setSelected(true);
        deleteAllRuns.setText("Delete all Runs");
        deleteAllRuns.setFont(displayScaleFont);
        deleteAllRuns.setBackground(backgroundColor);
        deleteAllRuns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                if(deleteAllRuns.isSelected()) deleteSelectedRuns.setSelected(false);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(deleteAllRuns, gridBagConstraints);

//        javax.swing.ButtonGroup group = new javax.swing.ButtonGroup();
//        group.add(deleteSelectedRuns);
//        group.add(deleteAllRuns);

        okButton.setText("Ok");
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(okButton, gridBagConstraints);
        okButton.requestFocusInWindow();

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(cancelButton, gridBagConstraints);

        deleteAllRuns.setEnabled(true);
        deleteSelectedRuns.setEnabled(true);

        pack();
    }


    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bOKActionPerformed
        confirmExit=true;
        closeDialog(null);
    }//GEN-LAST:event_bOKActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bOKActionPerformed
        closeDialog(null);
    }//GEN-LAST:event_bOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog

  private void fillTable() {
       try {
          Vector runVector = new Vector();
          java.util.regex.Pattern fpattern1 = java.util.regex.Pattern.compile(".*SctData::\\w*\\.(\\d+)\\.\\d+\\.(\\d{14}|SCTTestAPI_PseudoModule)");
          String dataDir;
          if((dataDir = System.getProperty("Sct.Scratch.Dir", null))!=null) {
            java.io.File scratchDir = new java.io.File(dataDir);
            if(scratchDir.exists()) {
              java.io.File[] isFiles = scratchDir.listFiles(new isFileFilter(".*SctData::.*"));
              int deletions=0, failedDeletions=0;
              for(int i=0;i<isFiles.length;i++) {
                String filename = isFiles[i].getName();
                java.util.regex.Matcher matcher = fpattern1.matcher(filename); 
                if(matcher.matches()) {
                    Integer runNo = Integer.valueOf(filename.substring(matcher.start(1),matcher.end(1)));
                    if(!runNumberHash.containsKey(runNo)) {
                       runNumberHash.put(runNo,new Integer(1));
                       runVector.addElement(runNo);
                       }
                    else {
                       int runCount = ((Integer)runNumberHash.get(runNo)).intValue();
                       runCount++;
                       runNumberHash.put(runNo,new Integer(runCount));
                       }
                  }
//                 else {System.out.println(filename+" did not match ...");}
//                if(isFiles[i].delete()) deletions++;
//                else failedDeletions++;
                }
              Collections.sort(runVector);
              Vector tableList = new Vector();
              Vector tableRow = new Vector();
              tableRow.addElement("Run Number");
              tableRow.addElement("# data files");
              tableList.addElement(tableRow);
              for(int i=0;i<runVector.size();i++) {
                 tableRow = new Vector();
                 Integer thisRunNo = (Integer)runVector.elementAt(i);
                 tableRow.addElement(thisRunNo);
                 tableRow.addElement((Integer)runNumberHash.get(thisRunNo));
                 tableList.addElement(tableRow);
                 }
              runTable.reTable(tableList);
            }       
          }
        }catch(Exception ioE){System.err.println("Exception deleting IS files: "+ioE.toString());}
   }

  private void deleteDataFiles() {
       try {
          String dataDir;
          if((dataDir = System.getProperty("Sct.Scratch.Dir", null))!=null) {
            java.io.File scratchDir = new java.io.File(dataDir);
            if(scratchDir.exists()) {
              String fileRegex = getFileRegex();
              if(fileRegex==null) return;
              java.io.File[] isFiles = scratchDir.listFiles(new isFileFilter(fileRegex));
              if(isFiles.length==0) return;
              System.out.println("Deleting "+isFiles.length+" data files ...");
              int deletions=0, failedDeletions=0;
              for(int i=0;i<isFiles.length;i++) {
                if(isFiles[i].delete()) deletions++;
                else failedDeletions++;
                }
              System.out.println(deletions+ " files confirmed deleted.");
              if(failedDeletions>0) System.out.println("*** "+failedDeletions + " files were not deleted!");
              }   
           }
       }catch(Exception ioE){System.err.println("Exception deleting IS files: "+ioE.toString());}   
     }

  private String getFileRegex() {
      if(deleteAllRuns.isSelected()) return ".*SctData::.*";
      else if(deleteSelectedRuns.isSelected()) {
        StringBuffer runString = new StringBuffer(".*SctData::\\w*\\.");
        javax.swing.ListSelectionModel rowSM = table.getSelectionModel();
        int selectCount=0;
        for(int i=0;i<runTable.getRowCount();i++) {
          if(!rowSM.isSelectedIndex(i)) continue;   
          selectCount++;       
          String runNo = ((Integer)runTable.getValueAt(i,0)).toString();
          if(i>0) runString.append("|");
          runString.append(runNo);
          }
        if(selectCount==0) return null;
        runString.append(".*");
        return runString.toString();
        }
      return null;
      }

  private void checkArchiveService() {
        try {
        ArchivingServiceI.ArchivingServiceInterface a = SystemInterface.getInstance().getArchivingService();
        AnalysisServiceI.AnalysisServiceInterface b = SystemInterface.getInstance().getAnalysisService();

        if(a!=null && (a.busy()>0 || a.queueLength()>0)) {
           System.out.println("SctGUI: Archiving Service busy or not finished - will not permit file deletions");
           deleteAllRuns.setSelected(false);
           deleteSelectedRuns.setSelected(false);
           deleteAllRuns.setEnabled(false);
           deleteSelectedRuns.setEnabled(false);
           return;
           }
        if(b!=null && (b.busy()>0 || b.queueLength()>0)) {
           System.out.println("SctGUI: Analysis Service busy or not finished - will not permit file deletions");
           deleteAllRuns.setSelected(false);
           deleteSelectedRuns.setSelected(false);
           deleteAllRuns.setEnabled(false);
           deleteSelectedRuns.setEnabled(false);
           return;
           }
         }catch(Exception e){System.err.println("SctGUI: communication failure with Archiving or Analysis Service - "+e.toString());}
         }


    
    
}
