/*
 * DatabaseLister.java
 *
 * Created on 27 February 2004, 13:50
 */

package DisplayGUI;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import java.util.*;
import ProdDatabase.*;

/**
 *
 * @author  robinson
 */
public class DatabaseLister extends javax.swing.JFrame implements displayParams, SCTDBInfo, TestDataInfo, ListSelectionListener {
    
    DataList dataList;
    Map testMap;
    ListSelectionModel rowSM;

    private javax.swing.JButton jButton1;
    private javax.swing.JTable jTable;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1,jLabel2;
    private javax.swing.JScrollPane jScrollPane1;

    /** Creates new form test */
    public DatabaseLister() {
        super("Download SctRodDaq Tests");
         createTestMap();
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
       
        java.awt.GridBagConstraints gridBagConstraints;

        jButton2 = new javax.swing.JButton();
        jButton2.setFont(displayTextFont);
        jComboBox1 = new javax.swing.JComboBox();
        jComboBox1.setFont(displayTextFont);
        jComboBox1.setBackground(backgroundColor);
        for(int i=0;i<testNames.length;i++) {
           if(testIsDefined[i] && i!=TEST_NMASK) jComboBox1.addItem(testMenuNames[i]);
           }
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        dataList = new DataList();
        jTable = new javax.swing.JTable(dataList);
        jTable.setFont(tableFont);
        jTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        rowSM = jTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        jScrollPane1 = new javax.swing.JScrollPane(jTable);
        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        jScrollPane1.setMinimumSize(new java.awt.Dimension(300, 150));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 200));
        jButton1 = new javax.swing.JButton();
        jButton1.setFont(displayTextFont);
        jButton3 = new javax.swing.JButton();
        jButton3.setFont(displayTextFont);

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        jButton2.setText("Download Selected Test");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        getContentPane().add(jButton2, gridBagConstraints);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                       int selectedRow = rowSM.getMinSelectionIndex();
                       String testname = (String)dataList.getValueAt(selectedRow,1);
                       Integer testIndex = (Integer)testMap.get(testname);
                       String r = (String)dataList.getValueAt(selectedRow,2);
                       String s = (String)dataList.getValueAt(selectedRow,3);
                       SCTDBTestDownloader d = new SCTDBTestDownloader(r+"-"+s,testIndex.intValue(),Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.INSTITUTE));
                       if(d.downloadsRequired() && d.isOkToStart()) d.start();
                       setVisible(false);
                     }
             });
        jButton2.setEnabled(false);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jComboBox1, gridBagConstraints);

        jLabel1.setText("Select Test:");
        jLabel1.setFont(displayTextFont);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.2;
        getContentPane().add(jLabel1, gridBagConstraints);

        jLabel2.setText("No Data listed...");
        jLabel2.setFont(displayScaleFont);  
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(2, 5, 0, 5);
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
//        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jButton1.setText("List Available Data");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.2;
        getContentPane().add(jButton1, gridBagConstraints);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                       Integer index = (Integer)testMap.get((String)jComboBox1.getSelectedItem());
                       if(index==null) return;
                       try {
                         String locn = Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.INSTITUTE);
                         if(locn.equals(Preferences.PreferencesInterface.unDefinedString)) {
                          javax.swing.JOptionPane.showMessageDialog(null,"You must define your location before downloading anything... use the Preferences menu.","SCT Database Download",javax.swing.JOptionPane.INFORMATION_MESSAGE);
                          return;
                          }
                         dataList.reTable(GeneralUtilities.getTestList(index.intValue(),locn,testMenuNames[index.intValue()]));
                         jLabel2.setText(dataList.getRowCount()+" "+(String)jComboBox1.getSelectedItem()+" tests are available.");
                       }catch(Exception e){System.err.println("Failed to retrieve test list - "+e.toString());} 
                    }
             });

        jButton3.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(jButton3, gridBagConstraints);
        jButton3.addActionListener(new java.awt.event.ActionListener() {
                 public void actionPerformed(java.awt.event.ActionEvent evt) {
                     exitForm(null);
                     }
             });
        getContentPane().setBackground(new java.awt.Color(255, 255, 255));

        pack();
    }

    /** method required by ListSelectionListener interface */
    public void valueChanged(ListSelectionEvent e) {

              if (e.getValueIsAdjusting()) return;

              ListSelectionModel lsm = (ListSelectionModel)e.getSource();
 
        
              if (lsm.isSelectionEmpty()) {
                   jButton2.setEnabled(false);
                   return;
                   }

              jButton2.setEnabled(true);
              }
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
       setVisible(false);
       dispose();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new DatabaseLister().show();
    }

public void createTestMap() {
    testMap = new HashMap();
    for(int i=0;i<testNames.length;i++) {
             testMap.put(testMenuNames[i],new Integer(i));

             }
    }

public class DataList extends javax.swing.table.AbstractTableModel {
    private String[] columnNames = {"Date","Test","Run","Scan"};
    List rows;

    public DataList() {
         rows=new ArrayList();
         }


    public void reTable(List rows) {
         this.rows=rows;
         fireTableChanged(null); // Tell the listeners a new table has arrived.
         return ;
    }



    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
            return getValueAt(0, column).getClass();

   }

    public boolean isCellEditable(int row, int column) {
            return false; 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return rows.size();
    }

    public Object getValueAt(int aRow, int column) {

        List theRow = (ArrayList)rows.get(aRow);
        return theRow.get(column);
    }


    public void setValueAt(Object value, int row, int column) {
        List dataRow = (List)rows.get(row);
        dataRow.set(column, value);
    }



}

    
    

    
}
