/**
ConfigurationInterface - class to retrieve configuration information for display GUI
Much hacked from Bruce's original doAll.java
@author robinson
*/
package DisplayGUI;
import org.omg.CORBA.IntHolder;
import ipc.*;
//import java.util.Hashtable;
//import java.util.Vector;
import java.util.*;
import GuiComponents.System.*;

public class ConfigurationInterface implements displayParams, SCTInfo {
    private static ConfigurationInterface instance = new ConfigurationInterface();
    private int maxWidth=0;
    private int midX=0, midY=0;
    private int moduleCount=0;
    private java.awt.Polygon polygon;
//    ModuleCell[][][] moduleCells = new ModuleCell[sctViews][][];
    ModuleCell[][][] moduleCells;
    double[] radius = {0.,0.,0.,0.,0.,0.};
    int[] xPoints = {0,0,0,0};
    int[] yPoints = {0,0,0,0};
    long fillsn=3000;

//    private Hashtable[] serialNumberMap = new Hashtable[sctViews];
    private SortedMap[] serialNumberMap = new TreeMap[sctViews];

    private Map snMap;
    private boolean dcsAvailable;

    sctConf.Configuration h;

    private ConfigurationInterface() {
        Refresh();
//        for(int i=0;i<sctViews;i++) serialNumberMap[i]=new Hashtable();
//        moduleCount=0;
        }

    public static ConfigurationInterface getInstance() {
        return instance;
    }

   public void setWindowSize(int maxWidth, int maxHeight) {
        this.maxWidth=maxWidth;
        midX=maxWidth/2;
        midY=maxHeight/2;
        maxWidth*=0.95;
        radius[0]=0.35 * (double)maxWidth/2.;
        radius[1]=0.52 * (double)maxWidth/2.;
        radius[2]= 0.5 * (double)maxWidth/2.;
        radius[3]= 0.76* (double)maxWidth/2.;
        radius[4]= 0.74  * (double)maxWidth/2.;
        radius[5]= maxWidth/2.;
        }

    public void Refresh() {
       for(int i=0;i<sctViews;i++) serialNumberMap[i]=new TreeMap();
       moduleCells = new ModuleCell[sctViews][][];
       snMap = new HashMap();
       dcsAvailable=false;
        moduleCount=0;   
     }

     public boolean isConfigured() {
         return (moduleCount>0);
         }

     public void getConfiguration() {
         getConfiguration(-1);
         }

     public void getConfiguration(int moduleGroup) {
	h = SystemInterface.getInstance().getConfigurationService();
        if(h==null) {
               System.err.println("Hardware configuration unavailable - is config_server running?");
               return;
               }
        try {
            int[] parts = h.listPartitions();
            for(int p=0; p<parts.length; p++) {
//                System.out.println("Partition " + p + " " + parts[p]);
                int[] crates = h.listCratesInPartition(parts[p]);
                for(int c=0; c<crates.length; c++) {
//                    System.out.println("Crate " + c + " " + crates[c]);
                    int[] rods = h.listRodsInCrate(parts[p], crates[c]);
                    for(int r=0; r<rods.length; r++) {
//                        System.out.println("Rod " + r + " " + rods[r]);
                        //sct.RodConfig rodConf = h.getRodConfig(parts[p], crates[c], rods[r]);
                        //System.out.println(rodConf.slaves[0].emifFile);

                        int[] MURs = h.listMURSInRod(parts[p], crates[c], rods[r]);
                        for(int mur=0; mur<MURs.length; mur++) {
//                            System.out.println("MUR " + mur + " " + MURs[mur]);
                            String[] modules = h.listModulesInMUR(parts[p], MURs[mur]);

                            for(int m=0; m<modules.length; m++) {
 //                               System.out.println("Module " + m + " " + modules[m]);

                                IntHolder MUR = new IntHolder(), num = new IntHolder();
                                h.translateFromSN(modules[m], MUR, num);

                                IntHolder partition = new IntHolder(), crate = new IntHolder(), rodno=new IntHolder(), channel=new IntHolder() ;
                                h.translateToROD(MUR.value, num.value, partition, crate, rodno, channel);

                                SNInfo snInfo = (SNInfo) snMap.get(modules[m]);
                                if(snInfo==null) snInfo = new SNInfo();
                                snInfo.set(SNInfo.PARTITION,Integer.toString(partition.value));
                                snInfo.set(SNInfo.ROD_CRATE,Integer.toString(crate.value));
                                snInfo.set(SNInfo.ROD_NUMBER,Integer.toString(rodno.value));
                                snInfo.set(SNInfo.ROD_CHANNEL,Integer.toString(channel.value));
                                snMap.put(modules[m],snInfo);   
 
                                try {
                                    moduleGroup = h.getModuleGroup(modules[m]);
                                }catch(Exception groupE){
                                    System.err.println("SctGUI::ConfigurationInterface - can't retrieve moduleGroup : "+groupE.toString());
                                    moduleGroup=0;
                                    }                 

                                IntHolder barrel = new IntHolder(), row = new IntHolder(), number = new IntHolder();
                                try {
                                  h.translateToBarrel(MUR.value, num.value, barrel, row, number);
                                  defineBarrelModuleGraphicsCell(barrel.value, row.value, number.value, MUR.value, moduleGroup, modules[m]);
                                } catch(sctConf.ConfigurationException eConfig) {
                                  h.translateToEndcap(MUR.value, num.value, barrel, row, number);
                                  defineEndCapModuleGraphicsCell(barrel.value, row.value, number.value, MUR.value, moduleGroup, modules[m]);
                                  }
                                try {
                                  h.translateToPowerSupply(MUR.value, num.value,partition,crate,channel);
                                  definePowerSupplyMapping(crate.value,channel.value,modules[m]);
                                }catch(Exception ee) {}
//               System.out.println("Module "+modules[m]+", Barrel " + barrel.value + ", Row " + row.value + ", Number " + number.value+", MUR "+MUR.value);

                            }
                        }
                    }
                }
            }
	} catch(sctConf.ConfigurationException eConfig) {
	    System.err.println("Configuration exception retrieving configuration " + eConfig.detail);
	    eConfig.printStackTrace();
        } catch(Exception e) {
            System.err.println("Non-configuration exception retrieving configuration ..." + e);
	    e.printStackTrace();
        }

     writeLookUpTable();
//        definePowerSupplyMapping(1,5,"20220330200020"); // dummy for test
//        definePowerSupplyMapping(1,6,"20220330200019"); // dummy for test
    }

   public void definePowerSupplyMapping(int crate, int channel, String sn) {

      dcsAvailable=true;
      SNInfo snInfo = (SNInfo) snMap.get(sn);
      if(snInfo==null) snInfo = new SNInfo();

      String crateString = Integer.toString(crate);
      snInfo.set(SNInfo.DCS_CRATE,crateString);
      String channelString = Integer.toString(channel);
      snInfo.set(SNInfo.DCS_CHANNEL,channelString);

      if(crateString.length()==1) crateString="0"+crateString;
      if(channelString.length()==1) channelString="0"+channelString;
      snInfo.set(SNInfo.DCS_HEADER,"Crate"+crateString+".Channel"+channelString+".");
      snInfo.set(SNInfo.IV_FILE_HEADER,"CRATE"+crateString+"CHAN"+channelString);

      snMap.put(sn,snInfo);
    
      }
   public String getSNInfo(String sn, int index) {
      SNInfo snInfo = (SNInfo) snMap.get(sn);
      if(snInfo==null) return "-1";
      return snInfo.get(index);
      }

    public boolean isDCSAvailable() {
      return dcsAvailable;
      }


    public String addModule(int barrel, int row, int number, int MUR, int moduleGroup, String serialNo) {

        for(int i=0;i<sctViews;i++) {
           if(serialNumberMap[i].containsKey(serialNo)) return "Module "+serialNo+" is already defined in "+SCTViewNames[i]; 
           } 

        for (Iterator i=serialNumberMap[barrel].entrySet().iterator(); i.hasNext(); ) {
              Map.Entry e = (Map.Entry) i.next();
              String thisSerialNo = (String)e.getKey();
              ModuleCell thisCell = (ModuleCell)e.getValue();
              if(thisCell.getRow()==row && thisCell.getModulePosition()==number) return "That location already taken by "+thisCell.getSerialNo();
              }
      int thisSCTView = barrel;

      try {
         moduleGroup = h.getModuleGroup(serialNo);
      }catch(Exception ee){System.err.println("SctGUI::ConfigurationInterface - can't retrieve moduleGroup : "+ee.toString());}

      if(barrel<4) {
            thisSCTView+=3;
            defineBarrelModuleGraphicsCell(thisSCTView, row, number, MUR, moduleGroup, serialNo);
            }
      else if(barrel>12) {
            thisSCTView-=12;
            defineEndCapModuleGraphicsCell(thisSCTView, row, number, MUR, moduleGroup, serialNo);
            }
      else {
            thisSCTView-=3;
            thisSCTView*=-1;
            defineEndCapModuleGraphicsCell(thisSCTView, row, number, MUR, moduleGroup, serialNo);
            }
      return null;
      }

    private void defineBarrelModuleGraphicsCell(int barrel, int row, int number, int MUR, int moduleGroup, String serialNo) {
        for(int i=0;i<sctViews;i++) {
           if(serialNumberMap[i].containsKey(serialNo)) {
              System.out.println("** Module "+serialNo+" defined more than once!");
              return;
              }   
           } 
	if(barrel < 3 || barrel > 6) {
	    System.out.println("** Module "+serialNo+" reported to be in nonexistant barrel " + barrel + "!");
	    return;
	}

        int thisSCTView=barrel-3;
        int moduleIndex = number;
        moduleIndex+=6;   // concert -6 to -1 to 0 thru 5, and 1 to 6 to 7 thru 12
        if(moduleIndex>5) moduleIndex--;  // bring it to 0 thru 11
        int thisRow=row;
        if(moduleCells[thisSCTView]==null) moduleCells[thisSCTView] = new ModuleCell[barrelRows[thisSCTView]][];
        if(moduleCells[thisSCTView][thisRow]==null) moduleCells[thisSCTView][thisRow] = new ModuleCell[12];

        int xloc=maxWidth/2 + number*boxWidth;
//        int yloc = yOffSet + (yOffSetCount[thisSCTView] + row)*boxHeight;
        int yloc = yOffSet + (yOffSetCount[thisSCTView] + barrelRows[thisSCTView] - row - 1)*boxHeight;

//        int yloc = yOffSet + (1 + row)*boxHeight;
        int[] xPoints = {xloc,xloc,xloc+boxWidth,xloc+boxWidth};
        int[] yPoints = {yloc,yloc+boxHeight,yloc+boxHeight,yloc};

        moduleCells[thisSCTView][thisRow][moduleIndex] = new ModuleCell(serialNo,thisSCTView,row,number,MUR,moduleGroup,xPoints,yPoints,4);
        serialNumberMap[thisSCTView].put(serialNo,moduleCells[thisSCTView][thisRow][moduleIndex]);
        moduleCount++;
    }

    private void defineEndCapModuleGraphicsCell(int disk, int quadrant, int number, int MUR, int moduleGroup, String serialNo) {
        for(int i=0;i<sctViews;i++) {
           if(serialNumberMap[i].containsKey(serialNo)) {
              System.out.println("** Module "+serialNo+" defined more than once!");
              return;
              }   
           } 
// end cap disks -1 to -9 map to sctViews 4 to 12
// end cap disks 1 to 9 map to sctViews 13 to 21
        int thisSCTView = (disk<0) ? 3-disk : 12+disk;
        if(moduleCells[thisSCTView]==null) moduleCells[thisSCTView] = new ModuleCell[4][];
        if(moduleCells[thisSCTView][quadrant]==null) moduleCells[thisSCTView][quadrant] = new ModuleCell[33];

        calculatePolygon(thisSCTView,quadrant,number);

        moduleCells[thisSCTView][quadrant][number] = new ModuleCell(serialNo,thisSCTView,quadrant,number,MUR,moduleGroup,xPoints,yPoints,4);
        serialNumberMap[thisSCTView].put(serialNo,moduleCells[thisSCTView][quadrant][number]);
        moduleCount++;
    }



    public ModuleCell getCell(int sctView, int x, int y) {
// return cell for positition x,y for given barrel
// index    0  1  2  3  4  5  6  7  8  9  10  11
// xIndex  -5 -4 -3 -2 -1  0  1  2  3  4  5   6
        if(sctView<4) {
//          int yIndex = (y-yOffSet-(yOffSetCount[sctView]*boxHeight))/boxHeight;
          int yIndex =  ((yOffSetCount[sctView]+barrelRows[sctView])*boxHeight - y + yOffSet)/boxHeight;
          if(yIndex<0 || yIndex>barrelRows[sctView]-1) return null;
          int diff = x -maxWidth/2;
          int xIndex = diff/boxWidth;
          if(diff>0 && xIndex==0) return null;  // inside middle gap
          xIndex+=5; // convert -5 to -0 to 0 thru 5, and 1 to 6 to 6 thru 11     
          if(xIndex<0 || xIndex>11) return null;   
          if(moduleCells[sctView]!=null && moduleCells[sctView][yIndex]!=null) {
              if(moduleCells[sctView][yIndex][xIndex]!=null) return moduleCells[sctView][yIndex][xIndex];
              }
          }
        else {
          // for endsaps, just enumerate through for the moment.
          // probably quicker than calculating explicity from x and y?
            for (Iterator i=serialNumberMap[sctView].entrySet().iterator(); i.hasNext(); ) {
               Map.Entry e = (Map.Entry) i.next();
               ModuleCell thisCell = (ModuleCell)e.getValue();
               if(thisCell.contains(x,y)) return thisCell;
               }
          } 
          return null;
    }

    public Hashtable getSerialNumberMap(int sctView) {
        return new Hashtable(serialNumberMap[sctView]);
        }
    public int getNumberOfModules(int sctView) {
        return serialNumberMap[sctView].size();
        }
    public int getTotalNumberOfModules() {
       return moduleCount;
       }
    public Set getSortedVector(int sctView) {
        return serialNumberMap[sctView].keySet();
      }
    public ModuleCell getModuleCell(int sctView, String serialNo) {
      return (ModuleCell)serialNumberMap[sctView].get(serialNo);
      }

    public void drawSCTViewOutline(java.awt.Graphics2D g2,int selection) {
        g2.setColor(java.awt.Color.lightGray);
        g2.setFont(displayTextFont);
        java.awt.FontMetrics metrics = g2.getFontMetrics();
        int rowNo=0;

        switch(selection) {
          case Barrel3:
          case Barrel4:
          case Barrel5:
          case Barrel6:
            int ilow = yOffSetCount[selection];
//            int ilow = 1;
            int ihigh = ilow+barrelRows[selection];
            int midX= maxWidth/2;

//            for(int y=ilow;y<ihigh;y++) {
            for(int y=ihigh-1;y>=ilow;y--) {
              String rowLabel = Integer.toString(rowNo);
              int labelWidth = metrics.stringWidth(rowLabel);
              int xLabel = midX - 6*boxWidth - labelWidth -8;

              int thisRow = rowNo;
              boolean rowUsed = (moduleCells[selection]!=null && moduleCells[selection][thisRow]!=null);
              g2.setColor(java.awt.Color.lightGray);
              for(int x=-6;x<=6;x++) {
                if(x==0) continue;                 
                g2.drawRect(midX+(boxWidth*x),yOffSet+(y*boxHeight), boxWidth, boxHeight);
                }
              java.awt.Color labelColor = rowUsed ? java.awt.Color.black : java.awt.Color.lightGray;  
              g2.setColor(labelColor);
              g2.drawString(rowLabel,xLabel,yOffSet+y*boxHeight+boxHeight);
              rowNo++;
              }
              g2.setColor(java.awt.Color.lightGray);
              g2.drawRect(midX - 6*boxWidth, yOffSet, 13*boxWidth, 56*boxHeight); //outer line for barrels 3,4,5
              break;
           case EndCap1a:
           case EndCap1c:
           case EndCap7a:
           case EndCap7c:
           case EndCap8a:
           case EndCap8c:
              for(int quadrant=0;quadrant<4;quadrant++) {
                 for(int number=13;number<23;number++) {
                     calculatePolygon(selection,quadrant,number);
                     if(polygon!=null) {
                        g2.setColor(java.awt.Color.white);
                        g2.fill(polygon);
                        g2.setColor(java.awt.Color.lightGray);
                        g2.draw(polygon);
                        }
                     }
                  }
              for(int quadrant=0;quadrant<4;quadrant++) {
                 for(int number=0;number<13;number++) {
                     calculatePolygon(selection,quadrant,number);
                     if(polygon!=null) {
                        g2.setColor(java.awt.Color.white);
                        g2.fill(polygon);
                        g2.setColor(java.awt.Color.lightGray);
                        g2.draw(polygon);
                        }
                     }
                 }
              break;
           case EndCap2a:
           case EndCap2c:
           case EndCap3a:
           case EndCap3c:
           case EndCap4a:
           case EndCap4c:
           case EndCap5a:
           case EndCap5c:   
           case EndCap6a:
           case EndCap6c:   
              for(int quadrant=0;quadrant<4;quadrant++) {
                 for(int number=13;number<23;number++) {
                     calculatePolygon(selection,quadrant,number);
                     if(polygon!=null) {
                        g2.setColor(java.awt.Color.white);
                        g2.fill(polygon);
                        g2.setColor(java.awt.Color.lightGray);
                        g2.draw(polygon);
                        }
                     }
                  }
              for(int quadrant=0;quadrant<4;quadrant++) {
                 for(int number=0;number<33;number++) {
                     if(number>=13 && number<23) continue;
                     calculatePolygon(selection,quadrant,number);
                     if(polygon!=null) {
                        g2.setColor(java.awt.Color.white);
                        g2.fill(polygon);
                        g2.setColor(java.awt.Color.lightGray);
                        g2.draw(polygon);
                        }
                     }
                 }
              break;     
           case EndCap9a:
           case EndCap9c:   
              for(int quadrant=0;quadrant<4;quadrant++) {
                 for(int number=0;number<13;number++) {
                     calculatePolygon(selection,quadrant,number);
                     if(polygon!=null) g2.draw(polygon);
                     }
                 }
              break;
           default:     

            }

 
    }

  private void calculatePolygon(int view, int quadrant, int number) {
        double thetaOffset=0.;
        double theta=0.;
        int rindex=0;
        int segment=0;
        int modules=0;
        if(number<13) {
             thetaOffset = Math.PI/52.;
             theta = Math.PI/26.;
             rindex=4;
             segment=number;
             modules=13;
             }
        else if(number>=13 && number<23) {
             thetaOffset=0.;
             theta = Math.PI/20.;
             rindex=2;
             segment=number-13;
             modules=10;
             }
        else {
             thetaOffset=Math.PI/40.;
             theta = Math.PI/20.;
             rindex=0;
             segment=number-23;
             modules=10;
             }
        segment += quadrant*modules;
        xPoints[0] = midX+(int)(radius[rindex]*Math.sin(segment*theta+thetaOffset));
        xPoints[1] = midX+(int)(radius[rindex]*Math.sin((segment+1)*theta+thetaOffset));
        xPoints[2] = midX+(int)(radius[rindex+1]*Math.sin((segment+1)*theta+thetaOffset));
        xPoints[3] = midX+(int)(radius[rindex+1]*Math.sin(segment*theta+thetaOffset));
        yPoints[0] = midY-(int)(radius[rindex]*Math.cos(segment*theta+thetaOffset));
        yPoints[1] = midY-(int)(radius[rindex]*Math.cos((segment+1)*theta+thetaOffset));
        yPoints[2] = midY-(int)(radius[rindex+1]*Math.cos((segment+1)*theta+thetaOffset));
        yPoints[3] = midY-(int)(radius[rindex+1]*Math.cos(segment*theta+thetaOffset));
        polygon = new java.awt.Polygon(xPoints,yPoints,4);
//        for(int i=0;i<4;i++) System.out.println("Polygon : Quadrant="+quadrant+" number="+number+" XY("+i+") : "+xPoly[i]+","+yPoly[i]);
        }

   public void updateModuleGroups(List cellList) {
       for(int i=0;i<cellList.size();i++) {
           ModuleCell thisCell = (ModuleCell)cellList.get(i);
           try {
              h.setModuleGroup(thisCell.getSerialNo(),(short)thisCell.getModuleGroup());
           }catch(Exception e){System.err.println("Exception setting modulegroup for module "+thisCell.getSerialNo()+" : "+e.toString());}
           }
       }
   private void writeLookUpTable() {
       String directory = Preferences.PreferencesInterface.getInstance().getPreference(Preferences.PreferencesInterface.WEB_LOOKUP_DIR);
       if(directory.equals(Preferences.PreferencesInterface.unDefinedString)) return;

       Map lookupMap = getLookUpMap(directory);

       for(int i=0;i<SCTViewNames.length;i++) {
          Set moduleList = getSortedVector(i);
          for (java.util.Iterator m = moduleList.iterator(); m.hasNext(); ) {
             String thisSN=(String)m.next();
             ModuleCell thisCell = getModuleCell(i,thisSN);
             String desc = SCTViewNames[i]+", Row "+thisCell.getRow()+", Position "+thisCell.getPosition();
             lookupMap.put(thisSN,desc);
             }
          }
        saveLookUpMap(directory,lookupMap);
        lookupMap=null; // might be large!!

        }
   private Map getLookUpMap(String directory) {
        Map thisMap = new HashMap();
        java.util.regex.Pattern p = java.util.regex.Pattern.compile("(\\d{14})=(.*)");
        java.io.File lookupFile = new java.io.File(directory,"moduleMap.txt");
        try {
          if(lookupFile.exists()) {
            java.io.BufferedReader in = new java.io.BufferedReader(new java.io.FileReader(lookupFile));
            String line;
            while((line=in.readLine())!=null) {
               java.util.regex.Matcher matcher = p.matcher(line);
               if(matcher.matches()) thisMap.put(line.substring(matcher.start(1),matcher.end(1)),line.substring(matcher.start(2),matcher.end(2)));
               }
            in.close();
           }
         }catch(Exception e){System.err.println("SctGUI::ConfigurationInterface - Exception reading in "+lookupFile.getName()+" - "+e.toString());}
         return thisMap;
         }
   private void saveLookUpMap(String directory,Map thisMap) {
        java.io.File lookupFile = new java.io.File(directory,"moduleMap.txt");
        int lineCount=0;
        try {
          java.io.BufferedWriter out = new java.io.BufferedWriter(new java.io.FileWriter(lookupFile));
          String line;
          for (Iterator i=thisMap.entrySet().iterator(); i.hasNext(); ) {
            Map.Entry e = (Map.Entry) i.next();
            out.write((String)e.getKey()+"="+(String)e.getValue());
            out.newLine();
            lineCount++;
            }
           out.close();
//           System.out.println("SctGUI::ConfigurationInterface - wrote "+lineCount+" records to "+lookupFile.getName());
         }catch(Exception e){System.err.println("SctGUI::ConfigurationInterface - Exception writing to "+lookupFile.getName()+" - "+e.toString());}         
         }
         
          
           


        


}
