#include <iostream>
#include <unistd.h>

#include "configXMLImpl.h"

int main(int argc, char **argv) {
  SctConfiguration::Configuration *cptr = new ConfigurationXMLImpl;

  SctConfiguration::Configuration &config = *cptr;

  std::string name = config.listModulesInMUR(0, 1).front();

  std::cout << "Found a module " << name << std::endl;

  ABCDModule conf = config.getModuleConfig(name);

  std::cout << "Sleeping...\n";
  sleep(2);
  std::cout << "...Slept\n";

  config.printModuleConfig(conf);

  config.configureModuleFromStructure(name, conf);
  config.configureROD(0, 0, 0, config.getRodConfig(0, 0, 0));

  unsigned int partition, crate, rod, channel;
  
  config.translateToROD(4, 4, partition, crate, rod, channel);

  std::cout << partition << ", " << crate << ", " << rod << ", " << channel << std::endl;
}
