#include <oks/relationship.h>
#include <sstream>
//  #include <confdb/dal.h>

#include "oksImpl.h"

using namespace SctConfiguration;

static string buildString(string base, int number);

OksImpl::OksImpl(bool readOnly) {
  int length = strlen(getenv("TDAQ_DB_PATH"));
  const char *schema_file = "/online/schema/online.schema.xml";
  char *schema_path = new char[length + strlen(schema_file)];

  strcpy(schema_path, getenv("TDAQ_DB_PATH"));
  strcpy(schema_path+length, schema_file);

  kernel.LoadSchema(schema_path);
  kernel.LoadSchema("SCTSchema.xml");

  const OksClass::Set &classSet = kernel.classes();

  for(OksClass::Set::const_iterator i = classSet.begin();
      i!=classSet.end();
      i++) {
    cout << (*i)->GetName() << endl; 
  }

  if(readOnly) {
    if( kernel.LoadData("loadConf.xml") != OksSuccess ) throw "";
  } else {
    // create new OKS data file
    if( kernel.NewData("newConf.xml") != OksSuccess ) throw "";
  }

  rodClass = kernel.FindClass ("SCT_RODModule");
  partClass = kernel.FindClass ("Partition");
  crateClass = kernel.FindClass ("Crate");
  murClass = kernel.FindClass("SCTModuleMUR");
  moduleClass = kernel.FindClass("SCTModule");
}

OksImpl::~OksImpl() {
  kernel.SaveAllData();
}

std::list<unsigned int> OksImpl::listPartitions() {
  int length = partClass->create_list_of_all_objects()->size();

  std::list<unsigned int> result;
  for(int i=0; i<length; i++) {
    result.push_back(i);
  }
  return result;
}

std::list<unsigned int> OksImpl::listCratesInPartition(unsigned int partition) {
  OksObject *partObj = getPartition(partition);

  OksData *relData;

  partObj->GetRelationshipValue("UsesDetectors", &relData);

  int length = 0;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *detObj = (*i)->data.OBJECT;

//     cout << "Found detector in partition\n" << detObj;

    OksData *detRelData;
    detObj->GetRelationshipValue("Contains", &detRelData);

    length += detRelData->data.LIST->size();
  }

  std::list<unsigned int> result;
  for(int i=0; i<length; i++)
    result.push_back(i);
  return result;
}

std::list<unsigned int> OksImpl::listRodsInCrate(unsigned int partition, unsigned int crate) {
  OksObject *crateObject = getCrate(partition, crate);

  OksData *relData;

  crateObject->GetRelationshipValue("Contains", &relData);

  std::list<unsigned int> result;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *rodObj = (*i)->data.OBJECT;

    OksData *position;
    rodObj->GetAttributeValue("Position", &position);
    result.push_back(position->data.USINT);
  }

  return result;
}

std::list<unsigned int> OksImpl::listMURSInRod(unsigned int partition, unsigned int crate, unsigned int rod) {
  OksObject *rodObject = getRod(partition, crate, rod);

  OksData *relData;
  rodObject->GetRelationshipValue("Contains", &relData);

  std::list<unsigned int> result;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *murObj = (*i)->data.OBJECT;

    OksData *id;
    murObj->GetAttributeValue("Number", &id);
    result.push_back(id->data.USINT);
  }

  return result;
}

std::list<std::string> OksImpl::listModulesInMUR(unsigned int partition, unsigned int MUR) {
  OksObject *murObject = getMUR(MUR);

  OksData *relData;
  murObject->GetRelationshipValue("Contains", &relData);

  std::list<std::string> result;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *murObj = (*i)->data.OBJECT;

    OksData *sn;
    murObj->GetAttributeValue("SerialNumber", &sn);
    result.push_back(string(*(sn->data.STRING)));
  }

  return result;
}

std::list<std::string> OksImpl::listRModulesInMUR(unsigned int partition, unsigned int MUR) {
  OksObject *murObject = getMUR(MUR);

  OksData *relData;
  murObject->GetRelationshipValue("ContainsR", &relData);

  std::list<std::string> result;

#warning "Need ordering correctly"
  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *murObj = (*i)->data.OBJECT;

    OksData *sn;
    murObj->GetAttributeValue("SerialNumber", &sn);
    result.push_back(string(*(sn->data.STRING)));
  }

  return result;

//   std::list<string> result;
// #warning UNIMPLEMENTED("RModules"); 
//   return result;
}

std::list<std::string> OksImpl::listAllModules()
{
  std::list<string> result;
  // #warning UNIMPLEMENTED("RModules"); 
  return result;
}

std::list<std::string> OksImpl::listUnusedModules()
{
  std::list<string> result;
// #warning UNIMPLEMENTED("RModules"); 
  return result;
}

ABCDModule OksImpl::getModuleConfig(std::string module) {
  ABCDModule result;
#warning UNIMPLEMENTED("Getmoduleconfig");
  return result;
}

RodConfig OksImpl::getRodConfig(unsigned int partition, unsigned int crate, unsigned int rod) {
  RodConfig result;

  OksObject *rodObject = getRod(partition, crate, rod);

  result.baseAddress = getULongData(rodObject, "VMEBaseAddress");
  result.mapSize = getULongData(rodObject, "VMEMapSize");
  result.numSlaves = 4;

  OksData *relData;
  rodObject->GetRelationshipValue("SlaveConfigs", &relData);

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *slaveObj = (*i)->data.OBJECT;

    int slaveNumber = getUShortData(slaveObj, "slaveNumber");

    result.slaves[slaveNumber].ipramFile = getStringData(slaveObj, "ipramFile");
    result.slaves[slaveNumber].idramFile = getStringData(slaveObj, "idramFile");
    result.slaves[slaveNumber].extFile = getStringData(slaveObj, "extFile");
  }

  return result;
}

BOCChannelConfig OksImpl::getBOCConfig(unsigned int partition, unsigned int crate, unsigned int rod, 
                              unsigned int channel) {
  BOCChannelConfig result;

  int mur = channel/6;
  int modulePosition = (channel % 6) + 1;

  OksObject *rodObject = getRod(partition, crate, rod);

  OksAttribute *pos = murClass->find_attribute("Position");
  OksData murNumber((unsigned short) mur);

  OksComparator comp(pos, &murNumber, OksQuery::equal_cmp);
  OksQuery murQuery(true, &comp);

//   cout << "Query " << murQuery << endl;

  OksData *relData;
  rodObject->GetRelationshipValue("Contains", &relData);

//   cout << "The ROD " << rodObject << endl;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *murObj = (*i)->data.OBJECT;

//     cout << "try this MUR " << murObj << endl;

//     cout << getUShortData(murObj, "Position") << endl;

#warning "What's wrong here!"
    if(getUShortData(murObj, "Position") == mur) { // murObj->SatisfiesQueryExpression(murQuery.get())) {
      OksAttribute *chanPos = kernel.FindClass("SCT_BOCChannel")->find_attribute("Position");
      OksData chanNumber((unsigned short) modulePosition);

      OksComparator comp2(chanPos, &chanNumber, OksQuery::equal_cmp);
      OksQuery channelQuery(true, &comp2);

//       cout << "Channel query " << channelQuery << endl;

      OksData *relData2;
      murObj->GetRelationshipValue("ChannelParams", &relData2);

      for(OksData::List::iterator i = relData2->data.LIST->begin(); i != relData2->data.LIST->end(); ++i) {
        OksObject *chanObj = (*i)->data.OBJECT;

//         cout << "try this Channel " << chanObj << endl;

        if(chanObj->SatisfiesQueryExpression(channelQuery.get())) {
          result.current = getUCharData(chanObj, "TXCurrent");
          result.delay = getUCharData(chanObj, "TXDelay");
          result.markSpace = getUCharData(chanObj, "TXMarkSpace");
          result.threshold0 = getUCharData(chanObj, "RX0Thresh");
          result.delay0 = getUShortData(chanObj, "RX0Delay");
          result.threshold1 = getUCharData(chanObj, "RX1Thresh");
          result.delay1 = getUShortData(chanObj, "RX1Delay");

          result.txFibre = getUCharData(chanObj, "TXFibre");
          result.rxFibre0 = getUCharData(chanObj, "RX0Fibre");
          result.rxFibre1 = getUCharData(chanObj, "RX1Fibre");

          return result;
        }
      }
    }
  }

  throw ConfigurationException("Can't find BOC parameters");
}

char *OksImpl::getFibreMappings(unsigned int partition, unsigned int crate, unsigned int rod) {
  static char mappings[48*3];
#warning Unimplemented 
  return mappings;
}

TimConfig OksImpl::getTimConfig(unsigned int partition, unsigned int crate) {
//    OksObject *crateObj = getCrate(partition, crate);

  TimConfig result;

#warning Unimplemented 
  return result;
}

void OksImpl::setFibreMapping(unsigned int partition, unsigned int crate, unsigned int rod, 
                              unsigned int channel, unsigned int tx, unsigned int rx0, unsigned int rx1) {
#warning Unimplemented 
}

void OksImpl::printModuleConfig(const ABCDModule &conf) {
#warning Unimplemented
}

SctConfiguration::MURType OksImpl::getMURType(unsigned int MUR)
{
  return SctConfiguration::UNMAPPED;
}

void OksImpl::translateToROD(unsigned int MUR, unsigned int module,
                    unsigned int &partition, unsigned int &crate, 
                    unsigned int &rod, unsigned int &channel) {
  OksObject *moduleObject = getModule(MUR, module);
  unsigned char modulePos = getUCharData(moduleObject, "Position");

  OksObject *murObject = getObjectFromRelationship(moduleObject, "PartOf");
  unsigned short murPos = getUShortData(murObject, "Position");

  channel = murPos * 6 + modulePos - 1;

  OksObject *rodObject = getObjectFromRelationship(murObject, "AssignedToROD");
  rod = (unsigned int)getUShortData(rodObject, "Position");

  OksObject *crateObject = getObjectFromRelationship(rodObject, "IsPartOf");
  std::string crateName = getStringData(crateObject, "Name");

  int length = crateName.length();

  partition = crateName[length - 2] - '0';
  crate = crateName[length - 1] - '0';

#warning Unimplemented 
}
 
void OksImpl::translateToRROD(unsigned int MUR, unsigned int module,
                     unsigned int &partition, unsigned int &crate, 
                     unsigned int &rod, unsigned int &channel) {
#warning Unimplemented 
}

void OksImpl::translateToSN(unsigned int MUR, unsigned int module,
                   std::string &sn) {
  OksObject *moduleObject = getModule(MUR, module);

  sn = getStringData(moduleObject, "SerialNumber");
}

void OksImpl::translateToBarrel(unsigned int MUR, unsigned int module,
                       unsigned int &barrel, unsigned int &row, int &number) {
#warning Unimplemented 
}

void OksImpl::translateToEndcap(unsigned int MUR, unsigned int module,
                       unsigned int &disk, unsigned int &ring, unsigned int &number) {
#warning Unimplemented 
}

void OksImpl::translateToPowerSupply(unsigned int MUR, unsigned int module,
                            unsigned int &partition, 
                            unsigned int &crate, unsigned int &channel) {
#warning Unimplemented 
}


void OksImpl::translateFromROD(unsigned int partition, unsigned int crate, 
                      unsigned int rod, unsigned int channel,
                      unsigned int &MUR, unsigned int &module) {
  OksObject *rodObject = getRod(partition, crate, rod);

  unsigned int order = channel / 6;
  unsigned int id = (channel % 6) + 1;

#warning Unimplemented 
}

void OksImpl::translateFromRROD(unsigned int partition, unsigned int crate, 
                      unsigned int rod, unsigned int channel,
                      unsigned int &MUR, unsigned int &module) {
//   OksObject *rodObject = getRod(partition, crate, rod);

//   unsigned int order = channel / 6;
//   unsigned int id = (channel % 6) + 1;

#warning Unimplemented 
}


void OksImpl::translateFromSN(const std::string sn,
                     unsigned int &MUR, unsigned int &module) {
  OksObject *moduleObject;

  OksAttribute *snAttr = moduleClass->find_attribute("SerialNumber");
  OksData snData(sn);
  OksComparator snComp(snAttr, &snData, OksQuery::equal_cmp);

  OksQuery moduleQuery(true, &snComp);

//   cout << "Trying to match Module (SN) " << moduleQuery << endl;

  OksObject::List *qList = moduleClass->execute_query(&moduleQuery);
  if(qList) {
    if(qList->size() == 0) {
      cout << "Found list of size " << qList->size() << endl;
      throw "Bad list size";
    } else {
      if(qList->size() != 1) {
        cout << "Module " << sn << " not unique!\n";
      }
      moduleObject = qList->front();
    }
  } else {
    throw "No response";
  }


  OksData *murData;
  OksData *posData;

  moduleObject->GetRelationshipValue("PartOf", &murData);
  moduleObject->GetAttributeValue("Position", &posData);

  module = (unsigned int)posData->data.UCHAR;

  OksObject *murObject = murData->data.OBJECT;

  murObject->GetAttributeValue("Number", &murData);

  MUR = (unsigned int)murData->data.USINT;
}


void OksImpl::translateFromBarrel(unsigned int barrel, unsigned int row, int number,
                         unsigned int &MUR, unsigned int &module) {
#warning Unimplemented 
}


void OksImpl::translateFromEndcap(unsigned int disk, unsigned int ring, unsigned int number,
                         unsigned int &MUR, unsigned int &module) {
#warning Unimplemented 
}

void OksImpl::translateFromPowerSupply(unsigned int partition, 
                                       unsigned int crate, unsigned int channel, 
                                       unsigned int &MUR, unsigned int &module)
{
}

void OksImpl::configureModuleFromStructure(const std::string module, const ABCDModule conf)
{
}

void OksImpl::configureModuleFromFile(const std::string filename)
{
}

void OksImpl::configureROD(unsigned int partition, unsigned int crate, unsigned int rod, SctConfiguration::RodConfig conf)
{
}

void OksImpl::configureTIM(unsigned int partition, unsigned int crate, SctConfiguration::TimConfig conf) 
{
}

void OksImpl::clearAll() {
#warning Unimplemented 
}


void OksImpl::namePartition(int partition, string name) {
#warning Unimplemented 
}

void OksImpl::createPartition(int partition) {
  OksObject *partObj = new OksObject("Partition", buildString("SCTpartition", partition).c_str());

  partObj->SetAttributeValue("Name", new OksData(buildString("SCTpartition", partition)));
}

void OksImpl::createCrate(int partition, int crate) {
  OksObject *crateObject = new OksObject(crateClass, buildString(buildString("SCTCrate", partition), crate).c_str());

  crateObject->SetAttributeValue("Name", new OksData(buildString(buildString("SCTCrate", partition), crate)));

  OksObject *partObj = partClass->get_object(buildString("SCTpartition", partition).c_str());

  OksObject *detObj = new OksObject(kernel.FindClass ("Detector"));

  partObj->AddRelationshipValue("UsesDetectors", detObj);
  detObj->AddRelationshipValue("Contains", crateObject);
}


void OksImpl::createROD(int partition, int crate, int rod, RodConfig conf) {
  OksObject *crateObject = getCrate(partition, crate);
  if(!crateObject) {
    createCrate(partition, crate);
    crateObject = getCrate(partition, crate);
  }

  OksObject *rodObject = new OksObject(rodClass);

  rodObject->SetAttributeValue("VMEBaseAddress", new OksData(conf.baseAddress));
  rodObject->SetAttributeValue("PhysAddress", new OksData(conf.baseAddress));

  rodObject->SetAttributeValue("VMEMapSize", new OksData(conf.mapSize));

  for(int i=0; i<conf.numSlaves; i++) {
    OksObject *slaveObj = new OksObject(kernel.FindClass("SCT_ROD_SlaveDSP"));

    slaveObj->SetAttributeValue("slaveNumber", new OksData((unsigned short)i));
    slaveObj->SetAttributeValue("ipramFile", new OksData(conf.slaves[i].ipramFile));
    slaveObj->SetAttributeValue("idramFile", new OksData(conf.slaves[i].idramFile));
    slaveObj->SetAttributeValue("extFile", new OksData(conf.slaves[i].extFile));

    rodObject->AddRelationshipValue("SlaveConfigs", slaveObj);
  }

  cout << "Setting position to " << rod << endl;
  rodObject->SetAttributeValue("Position", new OksData((unsigned short)rod));

  crateObject->AddRelationshipValue("Contains", rodObject);
  rodObject->SetRelationshipValue("IsPartOf", crateObject);
}

void OksImpl::createMUR(int partition, int crate, int rod, int order, int number) {
  OksObject *rodObject = getRod(partition, crate, rod);

  if(!rodObject) {
    cout << "Need to create ROD first!\n";
  } else {
    OksObject *murObject = new OksObject(murClass);

    rodObject->AddRelationshipValue("Contains", murObject);

    murObject->SetAttributeValue("Position", new OksData((unsigned char)order));
    murObject->SetAttributeValue("Number", new OksData((unsigned short)number));

    murObject->SetRelationshipValue("AssignedToROD", rodObject);
  }
}

void OksImpl::createModule(int MUR, int order, int RMUR, int rorder, string number, const ABCDModule &mConf) {
  OksObject *murObject = getMUR(MUR);

  OksData *data;

  murObject->GetAttributeValue("Number", &data);

  OksObject *moduleObject = new OksObject(moduleClass);

  murObject->AddRelationshipValue("Contains", moduleObject);
  moduleObject->SetAttributeValue("SerialNumber", new OksData(number));
  moduleObject->SetRelationshipValue("PartOf", murObject);
  moduleObject->SetAttributeValue("Position", new OksData((unsigned char)order));
}

void OksImpl::configureBOCChannel(int MUR, int order, const BOCChannelConfig &bConf) {
  OksObject *murObject = getMUR(MUR);

  OksObject *bocObject = new OksObject(kernel.FindClass("SCT_BOCChannel"));

  bocObject->SetAttributeValue("TXCurrent", new OksData((unsigned char)bConf.current));
  bocObject->SetAttributeValue("TXDelay", new OksData((unsigned char)bConf.delay));
  bocObject->SetAttributeValue("TXMarkSpace", new OksData((unsigned char)bConf.markSpace));
  bocObject->SetAttributeValue("RX0Thresh", new OksData((unsigned char)bConf.threshold0));
  bocObject->SetAttributeValue("RX0Delay", new OksData((unsigned short)bConf.delay0));
  bocObject->SetAttributeValue("RX1Thresh", new OksData((unsigned char)bConf.threshold1));
  bocObject->SetAttributeValue("RX1Delay", new OksData((unsigned short)bConf.delay1));

  bocObject->SetAttributeValue("Position", new OksData((unsigned short)order));

  murObject->AddRelationshipValue("ChannelParams", bocObject);
#warning Unimplemented 
}

void OksImpl::mapModuleMUR(int MUR, int order, int RMUR, int rorder, std::string number)
{
}

void OksImpl::mapRODMUR(int partition, int crate, int rod, int order, int number)
{
}

void OksImpl::mapBarrelMUR(int MUR, int barrel, int row, int position)
{
}

void OksImpl::swapMURNames(int MUR1, int MUR2)
{
}

void OksImpl::mapEndcapMUR(int MUR, int disk, int quadrant, int position)
{
}

void OksImpl::mapPowerChannel(int MUR, int number, unsigned int partition, unsigned int crate, unsigned int channel)
{
}

void OksImpl::modifyPowerParam(int MUR, int number, std::string name, float value)
{
}

void OksImpl::modifyDefaultPowerParam(std::string name, float value)
{
}

float OksImpl::getPowerParam(int MUR, int number, std::string name)
{
}

void OksImpl::loadConfiguration(const std::string &filename) {
#warning Unimplemented 
}

void OksImpl::saveConfiguration(std::string filename = "") {
#warning Unimplemented 
}

void OksImpl::saveModuleConfiguration(const std::string modsn, const std::string filename)
{
}

std::string OksImpl::getModuleConfigurationString(const std::string modsn, const ABCDModule config)
{
  return "OOps";
}

void OksImpl::writePowerSupplyConfiguration(std::string filename)
{
}

OksObject *OksImpl::getPartition(unsigned int p) {
  OksObject *partObj = partClass->get_object(buildString("SCTpartition", p).c_str());

  return partObj;
}

OksObject *OksImpl::getCrate(unsigned int p, unsigned int c) {
  OksObject *crateObject = crateClass->get_object(buildString(buildString("SCTCrate", p), c).c_str());

  return crateObject;
}

OksObject *OksImpl::getRod(unsigned int p, unsigned int c, unsigned int r) {
  string crateName = buildString(buildString("SCTCrate", p), c);

  OksObject *crateObject = crateClass->get_object(crateName.c_str());

#if 1
  std::ostringstream query;
  query << "(all ( and ( \"Position\" " << r << " = ) ( \"IsPartOf\" some \"" << crateName << "\" )))";

  std::string queryString(query.str());

  cout << queryString << endl;

  OksQuery rodQuery(rodClass, queryString);

  cout << "Try query " << rodQuery << endl;
#elif 1
  OksAttribute *pos = rodClass->find_attribute("Position");
  OksData rodNumber((unsigned short) r);

  OksComparator comp(pos, &rodNumber, OksQuery::equal_cmp);
  OksQuery rodQuery(true, &comp);

  OksData *relData;

  crateObject->GetRelationshipValue("Contains", &relData);

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksData *objData = *i;

    if(objData->data.OBJECT->SatisfiesQueryExpression(rodQuery.get())) {
      return objData->data.OBJECT;
    }
  }
#else
  OksAttribute *pos = rodClass->find_attribute("Position");
  OksData rodNumber((unsigned short) r);

  OksComparator comp(pos, &rodNumber, OksQuery::equal_cmp);

  OksAndExpression andExp;
  andExp.add(&comp);

  OksData name(crateName);
  OksComparator hasCrateName(crateClass->find_attribute("Name"), &name, OksQuery::equal_cmp);

  OksRelationship partOf("IsPartOf");
  OksRelationshipExpression inCrate(&partOf, &hasCrateName);
  andExp.add(&inCrate);
  OksQuery rodQuery(true, &andExp);
#endif

//   cout << "Trying to match ROD " << rodQuery << endl;

  OksObject::List *qList = rodClass->execute_query(&rodQuery);
  if(qList) {
//     cout << "Found list of size " << qList->size() << endl;
    if(qList->size() == 0) {
      return 0;
    } else {
      return qList->front();
    }
  } else {
    return 0;
  }
}

OksObject *OksImpl::getMUR(unsigned int m) {
  OksAttribute *pos = murClass->find_attribute("Number");
  OksData murNumber((unsigned short) m);

  OksComparator comp(pos, &murNumber, OksQuery::equal_cmp);

  OksQuery murQuery(true, &comp);

//    cout << "Trying to match MUR " << murQuery << endl;

  OksObject::List *qList = murClass->execute_query(&murQuery);
  if(qList) {
//      cout << "Found list of size " << qList->size() << endl;
    if(qList->size() == 0) {
      return 0;
    } else {
      if(qList->size() != 1) {
        cout << "MUR " << m << " not unique!\n";
      }
      return qList->front();
    }
  } else {
    return 0;
  }
}

OksObject *OksImpl::getModule(unsigned short mur, unsigned char position) {

//    OksAndExpression andExp;
//    andExp.add(&posComp);

  OksAttribute *murAttr = murClass->find_attribute("Number");
  OksData murNumber((unsigned short)mur);
  OksComparator murComp(murAttr, &murNumber, OksQuery::equal_cmp);

  OksQuery murQuery(true, &murComp);

//   cout << "Trying to match MUR (module stage 1)" << murQuery << endl;

  OksObject *murObject;

  OksObject::List *qList = murClass->execute_query(&murQuery);
  if(qList) {
    if(qList->size() == 0) {
      cout << "Found list of size " << qList->size() << endl;
      return 0;
    } else {
      if(qList->size() != 1) {
        cout << "MUR " << mur << " not unique!\n";
      }
      murObject = qList->front();
    }
  } else {
    return 0;
  }

  OksAttribute *posAttr = moduleClass->find_attribute("Position");
  OksData posNumber((unsigned char)position);
  OksComparator posComp(posAttr, &posNumber, OksQuery::equal_cmp);

  OksQuery moduleQuery(true, &posComp);
//   cout << "Trying to match module (stage 2)" << moduleQuery << endl;

  OksData *relData;
  murObject->GetRelationshipValue("Contains", &relData);

//   cout << "Got an object " << *murObject << endl;

  for(OksData::List::iterator i = relData->data.LIST->begin(); i != relData->data.LIST->end(); ++i) {
    OksObject *objData = (*i)->data.OBJECT;

//     cout << "Is this the right one " << *objData << endl;

    if(objData->SatisfiesQueryExpression(moduleQuery.get())) {
      return objData;
    }
  }

  cout << "No module " << position << " in MUR " << mur << endl;

  return 0;

//    OksRelationship partOf("PartOf");
//    OksRelationshipExpression inMUR(&partOf, &murComp);

//    andExp.add(&inMUR);
//    OksQuery moduleQuery(true, &andExp);

//    cout << "Trying to match module (MUR)" << moduleQuery << endl;

//    OksObject::List *qList = moduleClass->execute_query(&moduleQuery);
//    if(qList) {
//      cout << "Found list of size " << qList->size() << endl;
//      if(qList->size() == 0) {
//        return 0;
//      } else {
//        if(qList->size() != 1) {
//          cout << "Module " << mur << " " << position << " not unique!\n";
//        }
//        return qList->front();
//      }
  //    } else {
//      return 0;
//    }
}

OksObject *OksImpl::getObjectFromRelationship(const OksObject *obj, const std::string rel) {
  OksData *objData;
  obj->GetRelationshipValue(rel, &objData);
  return objData->data.OBJECT;
}

unsigned long OksImpl::getULongData(const OksObject *obj, const std::string attr) {
  OksData *objData;
  obj->GetAttributeValue(attr, &objData);
  return objData->data.ULINT;
}

unsigned short OksImpl::getUShortData(const OksObject *obj, const std::string attr) {
  OksData *objData;
  obj->GetAttributeValue(attr, &objData);
  return objData->data.USINT;
}

unsigned char OksImpl::getUCharData(const OksObject *obj, const std::string attr) {
  OksData *objData;
  obj->GetAttributeValue(attr, &objData);
  return objData->data.UCHAR;
}

std::string OksImpl::getStringData(const OksObject *obj, const std::string attr) {
  OksData *objData;
  obj->GetAttributeValue(attr, &objData);
  return std::string(*objData->data.STRING);
}

string buildString(string base, int number) {
  ostringstream result;
  result << base;
  result << number;
  return result.str();
}

