#include <stdio.h>
#include "CommonWithDsp/primParams.h"
#include "CommonWithDsp/memoryPartitions.h"

#define func(name) printf(" {%d,\t\"%s\"},\n", name, #name)

int main() {
  printf("struct ids { int id; char *name; };\n");
  printf("struct ids primNames[] = {\n");
  func(ECHO);
  func(SET_ERRMSG_MASK);
  func(PAUSE_LIST);
  func(EVENT_TRAP_SETUP);
  func(SET_MEMORY);
  func(COPY_MEMORY);
  func(MEMORY_TEST);
  func(SET_LED);
  func(FLASH_LED);
  func(SEND_DATA);
  func(MODULE_MASK); // func(TRIGGER_MASK);
  func(SET_TRIGGER);
  func(START_TASK);
  func(TASK_OPERATION);
  func(TEST);
  func(WRITE_BUFFER);
  printf("   // Last Common %d\n", LAST_COMMON_PRIMITIVE);

  printf("// Slave Primitives\n");
  func(START_EVENT_TRAPPING);
  func(STOP_EVENT_TRAPPING);
  func(HISTOGRAM_SETUP);
  //  func(RESET_APPLICATION);
  printf("   // Last Slave %d\n", LAST_SLAVE_PRIMITIVE);

  printf("// Master Primitives\n");
  func(RW_SLAVE_MEMORY);
  func(TRANS_SERIAL_DATA);
  func(START_SLAVE_EXECUTING);
  func(CONFIG_SLAVE);
  func(RW_REG_FIELD);
  func(POLL_REG_FIELD);
  func(RW_FIFO);
  func(SEND_SLAVE_LIST);
  func(START_SLAVE_LIST);
  func(SLAVE_LIST_OP);
  func(BUILD_STREAM);
  func(SEND_STREAM);
  func(RW_MODULE_DATA);
  func(SEND_CONFIG);
  func(DSP_RESET);
  func(SET_ROD_MODE);
  func(RW_MODULE_VARIABLE);
  func(RW_BOC_DATA);
  func(BOC_HISTOGRAM);
  printf("   // Last Master %d\n", LAST_MASTER_PRIMITIVE);

  printf(" {-1,\t\"\"}\n};\n");

  printf("struct ids taskNames[] = {\n");
  func(HISTOGRAM_CTRL_TASK);
  func(MIRROR_TASK);
  func(TRAP_REQ_TASK);
  printf("   // Last Master %d\n", LAST_MASTER_TASK);

  func(HISTOGRAM_TASK);
  func(TRAP_TASK);
  func(OCCUPANCY_TASK);
  func(ERROR_TASK);
  func(RESYNCH_TASK);
  printf("   // Last Slave %d\n", LAST_SLAVE_TASK);

  printf(" {-1,\t\"\"}\n};\n");
  
  printf("// Other stuff\n");
  printf("// Mdsp reply buffer %x \n", MDSP_REP_BFR_BASE);

  return 0;
}

