/*
 * ISHistogramAdapter.java
 *
 * Created on 27 November 2002, 12:19
 */

package oh.aida;
import hep.aida.*;
import oh.*;

/**
 *
 * @author  palmer
 */
public abstract class ISHistogramAdapter implements hep.aida.IHistogram {
    protected ISHistogram data;
    
    /** Creates a new instance of ISHistogramAdapter */
    public ISHistogramAdapter(ISHistogram data) {
        this.data = data;
    }
    
    protected void unimplementedFunction() {
        System.err.println("Error - unimplemented function called in :" + this);
        Thread.currentThread().dumpStack();
    }
    
    public int dimension() {
        return data.is_axis.length;
    }
    
    public hep.aida.IAnnotation annotation() {
        return new AnnotationAdapter();
    }
    
    public int entries() {
        return 0;
    }
    
    public void reset() throws java.lang.RuntimeException {
        unimplementedFunction();
    }
    
    public void setTitle(String str) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public String title() {
        return data.is_title;
    }
    
    public int allEntries() {
        return 0;
    }
    
    public double equivalentBinEntries() {        
        return 0.;
    }
    
    public int extraEntries() {
        return 0;
    }
    
    public double maxBinHeight() {
        unimplementedFunction();
        return 0;
    }
    
    public double minBinHeight() {
        unimplementedFunction();
        return 0;
    }
    
    public void scale(double param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public double sumAllBinHeights() {
        unimplementedFunction();
        return 0;
    }
    
    public double sumBinHeights() {
        unimplementedFunction();
        return 0;
    }
    
    public double sumExtraBinHeights() {
        unimplementedFunction();
        return 0;
    }
 
    /**
     *  Inner class to provide IAnnotation interface
     */
    class AnnotationAdapter implements IAnnotation {
        
        public void addItem(String str, String str1) throws java.lang.IllegalArgumentException {
            unimplementedFunction();
        }
        
        public void addItem(String str, String str1, boolean param) throws java.lang.IllegalArgumentException {
            unimplementedFunction();
        }
        
        public String key(int param) {
            return data.is_annotations[param*2];
        }
        
        public void removeItem(String str) throws java.lang.IllegalArgumentException {
            unimplementedFunction();
        }
        
        public void reset() {
            unimplementedFunction();
        }
        
        public void setSticky(String str, boolean param) {
            unimplementedFunction();
        }
        
        public void setValue(String str, String str1) {
            unimplementedFunction();
        }
        
        public int size() {
            return data.is_annotations.length/2;
        }
        
        public String value(String str) {
            for (int i=0; i<data.is_annotations.length; i+=2) {
                if (data.is_annotations[i].equals(str)) return data.is_annotations[i+1];
            }
            return null;
        }
        
        public String value(int param) {
            return data.is_annotations[param*2+1];
        }
        
    }
    
    class AxisAdapter implements IAxis {
        protected ISAxis axis;        ///< The index of this axis in the ISHistogram
        
        AxisAdapter(int index) {
            axis = data.is_axis[index];
        }
        
        public double binLowerEdge(int param) {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return axis.is_axis[0] + axis.is_axis[1] * (param-1);
            } else {
                unimplementedFunction();
                return 0;
            }
        }
        
        public double binUpperEdge(int param) {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return axis.is_axis[0] + axis.is_axis[1] * param;
            } else {
                unimplementedFunction();
                return 0;
            }  
        }
        
        public double binWidth(int param) {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return axis.is_axis[1];
            } else {
                unimplementedFunction();
                return 0;
            }  
        }
        
        public int bins() {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return (int)axis.is_axis[2];
            } else {
                unimplementedFunction();
                return 0;
            }  
        }
        
        public int coordToIndex(double param) {
            unimplementedFunction();
            return 0;
        }
        
        public boolean isFixedBinning() {
            return axis.is_type == ISHistogram.IS_FIXED;
        }
        
        public double lowerEdge() {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return axis.is_axis[0];
            } else {
                unimplementedFunction();
                return 0;
            }
        }
        
        public double upperEdge() {
            if (axis.is_type == ISHistogram.IS_FIXED) {
                return axis.is_axis[1] * axis.is_axis[2];
            } else {
                unimplementedFunction();
                return 0;
            }
        }
        
    }
    
    /**
     * Additional functions to make things easy for sub-classes
     */
    protected double _binError(int param) throws java.lang.IllegalArgumentException {
        //Two cases - one-sided or two-sided errors
        if (param >= data.is_errors.length) {
            java.lang.IllegalArgumentException e = new java.lang.IllegalArgumentException();
            throw e;
        }
        
        if (data.is_errors.length !=0) return data.is_errors[param];
        else if (data.is_minuserrors.length !=0 && data.is_pluserrors.length != 0) return data.is_pluserrors[param] + data.is_minuserrors[param];
        return 0;
    } 
    
    protected double _binHeight(int param) throws java.lang.IllegalArgumentException {
        if (param<data.is_bins.length) return data.is_bins[param];
        else {
            java.lang.IllegalArgumentException e = new java.lang.IllegalArgumentException();
            throw e;           
        }
    }
}
