#include "TH1.h"
#include "TH2.h"
#include "TCanvas.h"
#include "TSystem.h"
#include "SctData/ModuleConfiguration.h"
#include "SctData/ScanHeader.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/SctNames.h"
#include "SctData/RawScanResult.h"
#include "SctData/FitScanResult.h"
#include "SctData/TestResult.h"
#include "archiving/ArchRawScanResult.h"
#include "archiving/ArchFitScanResult.h"
#include "archiving/ArchTestResult.h"
#include "archiving/ArchNoiseOccupancyTestResult.h"
#include "archiving/ArchStrobeDelayTestResult.h"
#include "archiving/ArchNPtGainTestResult.h"
#include "archiving/ArchTrimRangeTestResult.h"
#include "archiving/ArchivingManager.h"
//#include "archiving/ArchTestNames.h"
#include "is/isinfo.h"
#include <iostream>
#include <vector>
//#include "Sct/shared_ptr_utility.h"

using namespace Sct;
using namespace SctData;
using namespace Sct::IS;
using namespace boost;





int main(int argc, char** argv) {
	cout << "Hello?" << endl;

	//Create IS/IPC objects
	IPCPartition& p = SctNames::getPartition();
	//ISInfoIterator iter(*p, SctNames::getControlDataName(), "Test.*");
	ISInfoIterator iter(p, SctNames::getTestDataName().c_str(), "SctData::NoiseOccupancyTestResult.*");
	ISInfoIterator iter1(p, SctNames::getTestDataName().c_str(), "SctData::NPtGainTestResult.*");
	ISInfoIterator iter2(p, SctNames::getTestDataName().c_str(), "SctData::StrobeDelayTestResult.*");
	ISInfoIterator iter3(p, SctNames::getTestDataName().c_str(), "SctData::TrimRangeTestResult.*");

       	
	vector<Serializable*> ptrs;

	cout << "IS/IPC objects created, iterating" << endl;
	cout << iter.entries() << " NoiseOccupancyTestResult objects in TestData IS server" << endl;
	cout << iter1.entries() << " NPtGainTestResult objects in TestData IS server" << endl;
	cout << iter2.entries() << " StrobeDelayTestResult objects in TestData IS server" << endl;
	cout << iter3.entries() << " TrimRangeTestResult objects in TestData IS server" << endl;
	

	
	//Now Archiving is virtual:
	//Archiving arch;
	//arch.ListISObj();
	//arch.SetUNIXDir();
	//cout << arch.getRunNumberFromIndex("Run551.ModuleSCTTestAPI_PseudoModule.SctData::NoiseOccupancyTestResult.")<<endl;
	//arch.ListOfModulesWithinTestInIndex(551,"NoiseOccupancyTest");
	//arch.ListOfRunsInIndex();


	//Iteration over ...TestResult  TestData objects in IS:
	cout << "######Iteration over ...TestResult objects in TestData IS" << endl;
	while (iter()) {
	  cout << iter.type().name() << endl;
	  
	  //Serializable* ob = arch.ISRetrieveObj(iter);
	  shared_ptr<Serializable> ob = IOManagerIS::instance().read(iter);
	  cout<< " Object retrieved: " << ob->getClassName() <<endl;
	  
	  
	  //NoiseOccupancyTestResult* test = dynamic_cast<NoiseOccupancyTestResult*>(ob);
	  shared_ptr<TestResult> test = dynamic_pointer_cast<TestResult>(ob);
	  shared_ptr<ArchTestResult> myTestArchiving = ArchivingManager::instance().getTestFromMap(ob);
	  shared_ptr<ArchTestResult> archtest = myTestArchiving->clone(test);
	  //ArchNoiseOccupancyTestResult archnotest(result);	  
	  archtest->SetUNIXDir();
	  archtest->Save();
	  
	  
	  
	}
	

	
	cout << "Finished" << endl;
}
