#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TSystem.h>
#include "SctData/ModuleConfiguration.h"
#include "SctData/ScanHeader.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/SctNames.h"
#include "SctData/RawScanResult.h"
#include "SctData/FitScanResult.h"
#include "archiving/ArchRawScanResult.h"
#include "archiving/ArchFitScanResult.h"
#include "archiving/ArchivingManager.h"
#include <is/isinfo.h>
#include <iostream>
#include <vector>
//#include "Sct/shared_ptr_utility.h"

using namespace Sct;
using namespace Sct::IS;
using namespace SctData;
using namespace boost;


/**
 * This is a simple test program that 
 * 1)retrieves RawScanResult objects from an IS server, stores them
 * and checks if they are persisted correctly 
 * 2) retrieves FitScanResult objects from an IS server, stores them.
 * 
 */


int main(int argc, char** argv) {
	cout << "Hello?" << endl;

	//Create IS/IPC objects
	IPCPartition& p = SctNames::getPartition();
	ISInfoIterator iter(p, SctNames::getEventDataName().c_str(), "SctData::RawScanResult.*");
	ISInfoIterator iter1(p, SctNames::getFittedDataName().c_str(), "SctData::FitScanResult.*");

	vector<Serializable*> ptrs;

	cout << "IS/IPC objects created, iterating" << endl;
	cout << iter.entries() << " Raw objects in IS server" << endl;
	cout << iter1.entries() << " Fitted objects in IS server" << endl;
	
	
	
	

	//Iteration over RawScanResult objecst in IS:
	cout << "######Iteration over RawScanResult objects in IS" << endl;
	while (iter()) {
		cout << iter.type().name() << endl;
		
		//Serializable* ob = arch.ISRetrieveObj(iter);
		//RawScanResult* rawscan = dynamic_cast<RawScanResult*>(ob);
		cout <<"I am here" <<endl;
		shared_ptr<Serializable> ob = IOManagerIS::instance().read(iter); //Doesn't work anymore ???
		cout <<"I am here" <<endl;
		cout <<"ClassName = " << ob->getClassName() <<endl;
		shared_ptr<ScanResult> scan = dynamic_pointer_cast<ScanResult>(ob);

		if (scan != 0) {
		  shared_ptr<ArchScanResult> myScanArchiving = ArchivingManager::instance().getScanFromMap(ob);
		  shared_ptr<ArchScanResult> archraw = myScanArchiving->clone(scan);
		  //ArchRawScanResult archraw(rawscan);
		  archraw->ListISObj();
		  archraw->SetUNIXDir();
		  archraw->Save();
		  //archraw->RawScanIsPersisted();
		  //archraw.AddScanToIndex();
		  //archraw.AddScanToIndex("Run1000","ModuleTestSubmit", "Stand-AloneScans", "Scan101" );
		  //archraw.IsTestInIndex(1000, "TestSubmit", "Stand-AloneScans");
		  //archraw.IsScanInIndex(1000, "TestSubmit", "Stand-AloneScans", 101);
		  //archraw.IsScanInIndex("Run1000","ModuleTestSubmit", "Stand-AloneScans", "Scan100" );
		  //archraw->UpdateScanIndex();
		
		} else {
		  
		  cout << "Error reading: " << iter.name() << endl;

		}
		//delete ob;
		cout << "Successfully retrieved RawScanResult" << endl;
		cout << "Next object.." << endl;
	}


	//Iteration over FitScanResult objects in IS:
	cout << "######Iteration over FitScanResult objects in IS" << endl;
	while (iter1()) {
		cout << iter1.type().name() << endl;
		
		//Serializable* ob = arch.ISRetrieveObj(iter1);
		//FitScanResult* fitscan = dynamic_cast<FitScanResult*>(ob);
		shared_ptr<Serializable> ob = IOManagerIS::instance().read(iter1);
		shared_ptr<ScanResult> scan = dynamic_pointer_cast<ScanResult>(ob);
		
		if (scan != 0) {
		  
		  shared_ptr<ArchScanResult> myScanArchiving = ArchivingManager::instance().getScanFromMap(ob);
		  shared_ptr<ArchScanResult> archfit = myScanArchiving->clone(scan);

		  //ArchFitScanResult archfit(fitscan);
		  archfit->SetUNIXDir();
		  archfit->Save();
		  //archfit.FitScanIsPersisted(); //Not working correctly at the moment
		  //archraw.AddScanToIndex();
		
		} else {
		  
		  cout << "Error reading: " << iter1.name() << endl;

		}
		//delete ob;
		cout << "Successfully retrieved FitScanResult" << endl;
		cout << "Next object.." << endl;
	}



	cout << "Finished" << endl;
}
