#ifndef ARCHIVINGMANAGER_H
#define ARCHIVINGMANAGER_H
#include <boost/utility.hpp>
#include <fstream>
#include <string>
#include <map>
#include <boost/shared_ptr.hpp>
#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"
#include "Sct/Serializable.h"
#include "Archiving.h"
#include "ArchScanResult.h"
#include "ArchTestResult.h"

using std::ofstream;
using std::map;
using std::ostream;
using std::string;


	

	class ArchivingManager : boost::noncopyable {
	public:
	    /** get the instance of the singleton*/ 
	    static ArchivingManager& instance() throw();
	    
	    bool addScanArchiver(const string& scanName, boost::shared_ptr<ArchScanResult> archiver) throw(Sct::LogicError);
	    bool addTestArchiver(const string& testName, boost::shared_ptr<ArchTestResult> archiver) throw(Sct::LogicError);
	    /** 
		get the appropriate ArchivingMap for the ScantResult
		@param classname the name of the TestResult for which the summary is to be written.
	     */
	    boost::shared_ptr<ArchScanResult> getScanFromMap(shared_ptr<const Serializable> ob) const throw(Sct::LogicError); 
	    boost::shared_ptr<ArchTestResult> getTestFromMap(shared_ptr<const Serializable> ob) const throw(Sct::LogicError);
	private:
      	    ~ArchivingManager(); 
	    ArchivingManager(); 
	    
	    
	    typedef map<string, boost::shared_ptr<ArchScanResult> > ArchivingScanMap;
	    typedef map<string, boost::shared_ptr<ArchTestResult> > ArchivingTestMap;
	    /** 
		maps TestResult names to SummaryWriters 
	    */
	    ArchivingScanMap theScanMap;
	    ArchivingTestMap theTestMap;

	};


#endif // #ifndef SCTDATA_ARCHIVINGMANAGER
