#ifndef ArchStrobeDelayTestResult_H
#define ArchStrobeDelayTestResult_H


#include "Sct/SctNames.h"
#include "ArchTestResult.h"
#include "SctData/StrobeDelayTestResult.h"
#include <TVectorD.h>
#include <vector>


using namespace SctData;
using namespace Sct;


class ArchStrobeDelayTestResult: public  ArchTestResult {
  
 private:
  double  fraction;
  vector<double>  optima;

  TVectorD* vfraction;
  TVectorD* voptima;

  static bool inMap;
  
  ArchStrobeDelayTestResult(shared_ptr<StrobeDelayTestResult>);

 public: 

  ArchStrobeDelayTestResult();
  virtual shared_ptr<ArchTestResult> clone(shared_ptr<TestResult> test) {
                                   shared_ptr<StrobeDelayTestResult> SDtest = dynamic_pointer_cast<StrobeDelayTestResult>(test);
                                   return shared_ptr<ArchTestResult>(new ArchStrobeDelayTestResult(SDtest));
  } 
  ~ArchStrobeDelayTestResult();
 
  void SaveStrobeDelayTestDataOnly();
  void Save();
  void TestSummary(shared_ptr<StrobeDelayTestResult>);
   
};


#endif
