#include "ArchRawScanResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TBuffer.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>



/********************************** ArchScan Methods Definitions ************************/


bool ArchRawScanResult::inMap = ArchivingManager::instance().addScanArchiver("SctData::RawScanResult", shared_ptr<ArchScanResult>(new ArchRawScanResult())); 

/***********************  Constructor  *************** */

ArchRawScanResult::ArchRawScanResult(): ArchScanResult()  {

  cout<< "I am in the ArchRawScanResult Default Constructor"<< endl;
 
  
}
  
  
ArchRawScanResult::ArchRawScanResult(shared_ptr<const RawScanResult>  raw): ArchScanResult(raw)  {

  cout<< "I am in the ArchRawScanResult Constructor"<< endl;
  

  /*--- Initialisation ---*/
   
  theRaw=raw;
  
  //TH2D *scan0 = &raw->getScanData(0);
  //cout << "Scan 0 is: " << scan0 << endl;
  //scan0->Print();
  //RawData_link0 = shared_ptr<TH2D> ( new TH2D(raw->getScanData(0)) );
  //cout << "RawData_link0 is: " << RawData_link0.get() << endl;

  //TH2D *scan1 = &raw->getScanData(1);
  //cout << "Scan 1 is: " << scan1 << endl;
  //RawData_link1 = shared_ptr<TH2D> ( new TH2D(raw->getScanData(1)) );
  //cout << "RawData_link1 is: " << RawData_link1.get() << endl;
 

  //cout << "RawData link0 bins: " << RawData_link0->GetNbinsY() <<endl; 
  //cout << "RawData link1 bins: " << RawData_link1->GetNbinsY() <<endl;  
  
}




/**********************  Other Member Functions  *********************/

ArchRawScanResult::~ArchRawScanResult()  {
  
  cout << "I am in the ArchRawScanResult destructor" << endl;
  
  
  
}




void ArchRawScanResult::SetRawScan(shared_ptr<RawScanResult> raw)  {
  
  /*--- Initialisation ---*/
  theRaw=raw;

  SetScan(raw);

  //RawData_link0 = shared_ptr<TH2D> ( new TH2D(raw->getScanData(0)) );
  //RawData_link1 = shared_ptr<TH2D> ( new TH2D(raw->getScanData(1)) );
  

  //cout << "RawData link0 bins: " << RawData_link0->GetNbinsY() <<endl; 
  //cout << "RawData link1 bins: " << RawData_link1->GetNbinsY() <<endl;  
  
  

}



void ArchRawScanResult::SaveRawScan() {   

  //TO DO : Save time and date of first and last saving
 
  string TH2Dlink0 = names->getTH2Dlink0();
  string TH2Dlink1 = names->getTH2Dlink1();
  string ScanPointsID = names->getScanPointsID() ;
  string vpointsID = names->getvpointsID();
  string vNEventsID = names->getvNEventsID();
  string vNErrorEventsID = names->getvNErrorEventsID(); 
  string filename = names->getfilename();
  //string objName = ;  //To be deleted
  string variable = names->getVariable(); 
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string DCSID = names->getDCSID();
  string RawID = names->getRawID();
  string FitID = names->getFitID();
  string ModuleConfigID = names->getModuleConfigID();



  /* OPENING TEST FILE  */
  cout << "Opening file..."<<endl; 
 

  /*
  TObject *storage_file = gROOT->FindObjectAny(filename) ;
  if (!storage_file) { 
    cout << "no such file " << endl;
    //TFile *storage_file = new TFile(filename,"update");
  }
  else {
    cout << "The file already exists " << endl;
    TFile *storage_file = new TFile(filename,"update");
  }
  */

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    //storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    /* Already saved in ArchScanResult
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    */


    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    


    
    /* Making TestType   */
    cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }

    
    /* Making ScanType   */
    cout<<"I am making scanType Dir "<<endl;
    this_testType->cd();  //make this_testType the current directory 
    TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
    //cout<<"The Scan Type is "<< variable <<endl;
    
    
    if (!this_variable) {
      //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
      this_variable = gDirectory->mkdir(variable.c_str());
    }
     

    

    /* Making variable   */
    cout<<"I am making variable Dir "<<endl;
    this_variable->cd();  //make this_test the current directory
    TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
    //cout<<"The SCAN is "<< scanID <<endl;
    
    if (!this_scan) {
      //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
      this_scan =gDirectory ->mkdir(scanID.c_str());
    }
    this_scan->cd(); 


    /* Saving ScanNumber as a TVector: it is saved only once, just the first time   */
    /* Already saved in ArchScanResult
    TObject* pers_scannumber = gDirectory->FindObjectAny(scanID.c_str());
    if (!pers_scannumber) {
      double fscanNumber = scanNumber;
      TVector vscan(1,1,fscanNumber,"END");
      vscan.Write(scanID.c_str());
    }
    */


    //Saving Module Configuration
    /* Already saved in ArchScanResult
    TObject* pers_ModuleConfig = gDirectory->FindObjectAny(ModuleConfigID.c_str());
    if (!pers_ModuleConfig) {
      //cout<<"%%%%%%% Just about to save ABCDModule %%%%%%%"<<endl;
      TObjString ModuleConfigTObjString = getModuleConfigTObjString();
      //TString tmp_string = ModuleConfigTObjString.String();
      //cout<< "Module Configuration :" << endl << tmp_string.Data()<<endl;
      ModuleConfigTObjString.Write(ModuleConfigID.c_str()); 
      //cout<<"%%%%%%% ABCDModule saved %%%%%%%"<<endl;
    }
    */




    /* Threshold saved as a TVector: it is saved only once, just the first time */ 
/*    
      TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str());  
      if (!pers_Threshold) {
      cout << "The Threshold never saved before...saving now"<<endl;
      double fthreshold = threshold;
      TVectorD vthreshold(1,1,fthreshold,"END");
      vthreshold.Write(thresholdID.c_str());
    }

*/


    /* Saving ScanPoints as a TGraph: it is saved only once, just the first time  */
    //cout << "I am Saving ScanPoints as a TGraph" << endl;
    //TObject* pers_gscanpoints = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
    //if (!pers_gscanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      //AT  gpoints->Write(ScanPointsID.c_str());
    //}
    

    
    ///* Saving ScanPoints as a TVector: it is saved only once, just the first time  */
    //cout << "I am Saving ScanPoints as  TVector's" << endl;
    //TObject* pers_vscanpoints = gDirectory->FindObjectAny(vpointsID.c_str()); 
    //if (!pers_vscanpoints) {
      //cout << "The ScanPoints never saved before...saving now"<<endl;
      //AT   vpoints->Write(vpointsID.c_str());  
    //}
    //TObject* pers_vNEvents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
    //if (!pers_vNEvents) {
      //cout<< "I am here " << endl;
      //AT   vNEvents->Write(vNEventsID.c_str());  
    //}
     //TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
    //if (!pers_vNErrorEvents) {
    //AT   vNErrorEvents->Write(vNErrorEventsID.c_str());  
    //}      



    /* Making DCS   */
    //cout<<"I am making DCS Dir"<<endl;
      /*
    this_scan->cd();  //make this_scan the current directory
    TDirectory*  this_DCS = (TDirectory*) this_scan->Get(DCSID.c_str()); 
    //NB: DCS & ROD are at the same level. 
    if (!this_DCS) {
      //cout<<"This NEW DCS  doesn't exist"<<endl;
      this_DCS = this_scan->mkdir(DCSID.c_str());
    }
    
      */
   

    /* Saving DCS data members  */
      /*
    //cout << "I am Saving DCS RawScanResult Data Members" << endl;
    this_DCS->cd();  
      */


    /* Making ROD   */ 
    cout<<"I am making ROD Dir"<<endl;
    this_scan->cd();  //make this_scan the current directory
    TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
    //NB: DCS & ROD are at the same level: this_scan .Get(DCSID.c_str())
     
    if (!this_ROD) {
      //cout<<"This NEW ROD  doesn't exist"<<endl;
      this_ROD = this_scan->mkdir(RODID.c_str());
    }
    
  
        

    
    /* Making ROD Raw    */
    cout<<"I am making Raw Dir"<<endl;
    this_ROD->cd();
    TDirectory* this_raw = (TDirectory*) this_ROD->Get(RawID.c_str()); 
    /*NB: Fitted & Raw are at the same level: they can descend from DCS or ROD For this reason gDirectory.Get("...")*/

    if (!this_raw) {
      //cout<<"This NEW Raw Data  doesn't exist"<<endl;
      this_raw = this_ROD->mkdir(RawID.c_str());
    }
    
 

    /* Saving ROD Raw data members  */
    cout << "I am Saving ROD raw RawScanResult Data Members " << endl;
    this_raw->cd();  //make this_scan the current directory
    //for (vector<TH2D*>::iterator i = RawData.begin(); i!=RawData.end(); i++) {
    //(*i)->Write("RawData");
    //}


    cout<<"I am before Saving RawData_links"<<endl;
    //RawData_link0->Write(TH2Dlink0.c_str());
    //RawData_link1->Write(TH2Dlink1.c_str());
    
    theRaw->getScanData(0).Write(TH2Dlink0.c_str()); //crashes!!
    theRaw->getScanData(1).Write(TH2Dlink1.c_str()); //crashes!!
    
    cout<<"I am after Saving RawData_links"<<endl;
    

    /* CLOSING FILE  */
    cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    cout << "File closed " << endl;

}




void ArchRawScanResult::SaveRawScan(shared_ptr<RawScanResult>  s) {

   ArchRawScanResult tmp_receiver(s); 
   tmp_receiver.SaveRawScan();

}

void ArchRawScanResult::Save() {
  
  ArchScanResult::Save();
  SaveRawScan();

}


void ArchRawScanResult::Save(shared_ptr<RawScanResult> s) {
  
  ArchRawScanResult tmp_receiver(s); 
  tmp_receiver.Save();

}


bool ArchRawScanResult::RawScanIsPersisted()  {

  /* Check if the current RawScanResult of the current Test has been persisted*/
   

  string TH2Dlink0 = names->getTH2Dlink0();
  string TH2Dlink1 = names->getTH2Dlink1();
  string ScanPointsID = names->getScanPointsID() ;
  string vpointsID = names->getvpointsID();
  string vNEventsID = names->getvNEventsID();
  string vNErrorEventsID = names->getvNErrorEventsID(); 
  string filename = names->getfilename();
  //string objName = ;  //To be deleted
  string variable = names->getVariable(); 
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string DCSID = names->getDCSID();
  string RawID = names->getRawID();
  string FitID = names->getFitID();
  string thresholdID = names->getThresholdID();


  
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "The RawScanResult has NOT been saved in any file"<<endl; 
    return 1;
  }
  
  
  gDirectory->cd(runID.c_str());
  TDirectory* inspect_dir = (TDirectory*) gDirectory->Get(moduleID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved"<<endl;
      return 1;
  }
  gDirectory->cd(moduleID.c_str());
   

  gDirectory->cd(testType.c_str());


  gDirectory->cd(variable.c_str());
  inspect_dir = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved"<<endl;
      return 1;
  }
  gDirectory->cd(scanID.c_str());
  
  /*
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  if (!pers_Threshold) {
    cout << "The RawScanResult has NOT been saved"<<endl;
    return 1;
  }

*/

  //Check if ScanPoints are saved as TGraph
  TObject* pers_RawTH1 = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
  if (!pers_RawTH1) {
    cout << "The RawScanResult has NOT been saved"<<endl;
    return 1;
  }

  
  //Check if ScanPoints are saved as TVector's
  TObject* pers_points = gDirectory->FindObjectAny(vpointsID.c_str()); 
  if (!pers_points) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_Nevents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
  if (!pers_Nevents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
  if (!pers_vNErrorEvents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }

  gDirectory->cd(RODID.c_str());
  gDirectory->cd(RawID.c_str());

  cout << "Looking for persisted histograms in Raw Data" << endl;
  //gDirectory->ls();


  //Check if the two TH2D hist's have been persisted
  TObject* pers_RawTH2link0 = gDirectory->FindObjectAny(TH2Dlink0.c_str()); 
  if (!pers_RawTH2link0) {
    cout << "The RawScanResult has NOT been saved"<<endl;
    return 1;
  }

  TObject* pers_RawTH2link1 = gDirectory->FindObjectAny(TH2Dlink1.c_str()); 
  if (!pers_RawTH2link1) {
    cout << "The RawScanResult has NOT been saved"<<endl;
    return 1;
  }

  inspect_file->Close();
  delete inspect_file;  

  cout << "RawScanResult has been PERSISTED" << endl;
  return 0;


}






bool ArchRawScanResult::RawScanIsPersisted(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable, unsigned int cycle)  {

  /* Check if the current RawScanResult of the current Test has been persisted*/
  
  ArchScanNames *new_names= new ArchScanNames(runNumber,moduleName,scanNumber, variable, cycle ); 

  string TH2Dlink0 = new_names->getTH2Dlink0();
  string TH2Dlink1 = new_names->getTH2Dlink1();
  string ScanPointsID = new_names->getScanPointsID() ;
  string vpointsID = new_names->getvpointsID();
  string vNEventsID = new_names->getvNEventsID();
  string vNErrorEventsID = new_names->getvNErrorEventsID(); 
  string filename = new_names->getfilename();
  //string objName = ;  //To be deleted
  string sVariable = new_names->getVariable();   //!!!!
  string moduleID = new_names->getModuleID(); 
  string testType  = new_names->getTestType(); 
  string runID = new_names->getRunID();
  string scanID = new_names->getScanID();
  string RODID = new_names->getRODID();
  string DCSID = new_names->getDCSID();
  string RawID = new_names->getRawID();
  string FitID = new_names->getFitID();
  string thresholdID = new_names->getThresholdID();

  //


  /* Variable initialisation */


  /* Opening File */
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "The RawScanResult has NOT been saved in any file"<<endl; 
    return 1;
  }
  
  
  gDirectory->cd(runID.c_str());
  TDirectory* inspect_dir = (TDirectory*) gDirectory->Get(moduleID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved...moduleID"<<endl;
      return 1;
  }
  gDirectory->cd(moduleID.c_str());


  TDirectory* testType_dir = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!testType_dir) {
      cout<<"The RawScanResult has NOT been saved...testType"<<endl;
      return 1;
  }
  gDirectory->cd(testType.c_str());


  TDirectory* pers_variable = (TDirectory*) gDirectory->Get(sVariable.c_str());
  if (!pers_variable) {
      cout<<"The RawScanResult has NOT been saved...variable"<<endl;
      return 1;
  }
  gDirectory->cd(sVariable.c_str());


  inspect_dir = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!inspect_dir) {
      cout<<"The RawScanResult has NOT been saved...scanID"<<endl;
      return 1;
  }
  gDirectory->cd(scanID.c_str());
  
  /*
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  if (!pers_Threshold) {
    cout << "The RawScanResult has NOT been saved...thresholdID"<<endl;
    return 1;
  } 
  */

  //Check if ScanPoints are saved as TGraph
  TObject* pers_RawTH1 = gDirectory->FindObjectAny(ScanPointsID.c_str()); 
  if (!pers_RawTH1) {
    cout << "The RawScanResult has NOT been saved...ScanPointsID"<<endl;
    return 1;
  }
  
  //Check if ScanPoints are saved as TVector's
  TObject* pers_points = gDirectory->FindObjectAny(vpointsID.c_str()); 
  if (!pers_points) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_Nevents = gDirectory->FindObjectAny(vNEventsID.c_str()); 
  if (!pers_Nevents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str()); 
  if (!pers_vNErrorEvents) {
    cout << "The RawScanResult has NOT been saved...ScanPoints"<<endl;
    return 1;
  }


  gDirectory->cd(RODID.c_str());
  gDirectory->cd(RawID.c_str());

  cout << "Looking for persisted histograms in Raw Data" << endl;
  //gDirectory->ls();


  //Check if the two TH2D hist's have been persisted
  TObject* pers_RawTH2link0 = gDirectory->FindObjectAny(TH2Dlink0.c_str()); 
  if (!pers_RawTH2link0) {
    cout << "The RawScanResult has NOT been saved...TH2Dlink0"<<endl;
    return 1;
  }

  TObject* pers_RawTH2link1 = gDirectory->FindObjectAny(TH2Dlink1.c_str()); 
  if (!pers_RawTH2link1) {
    cout << "The RawScanResult has NOT been saved...TH2Dlink1"<<endl;
    return 1;
  }
  

  cout << "RawScanResult has been PERSISTED" << endl;
  return 0;


}








bool ArchRawScanResult::RawScanIsPersisted(shared_ptr<RawScanResult>  rawdata)  {

  ArchRawScanResult temp_dir(rawdata);
  return temp_dir.RawScanIsPersisted();

}




RawScanResult* ArchRawScanResult::CreateRawScanResult() {
  
  
  string Pers_Modulename;

  if ( RawScanIsPersisted() == 0 ) //To be modified: retrieve histo's and data from file
  { 
      
      cout << "...creating new RawScanResult obj from persistency" << endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      int dot = Archheader->getModuleName().find('.');
      string Pers_ModuleID = Archheader->getModuleName().substr(0, dot).c_str();  
      Pers_Modulename = Pers_ModuleID + ".Persisted";
      
  

   } else {

     cout << "WARNING: the RawScanResult has NOT been persisted!!" <<endl;
     //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
     int dot = Archheader->getModuleName().find('.');
     string Pers_ModuleID = Archheader->getModuleName().substr(0, dot).c_str();   
     Pers_Modulename = Pers_ModuleID + ".Unpersisted";
     
     
   }
  

  shared_ptr<TH2D> RawData_link0 = shared_ptr<TH2D> ( new TH2D(theRaw->getScanData(0)) );
  shared_ptr<TH2D> RawData_link1 = shared_ptr<TH2D> ( new TH2D(theRaw->getScanData(1)) );


  ScanHeader s(scanNumber, runNumber, Pers_Modulename , *Archvariable);
  RawScanResult* r = new RawScanResult(s, *ArchmoduleConfig, *Archpoints, *RawData_link0, *RawData_link1 );
 

  cout<< r->getHeader().getModuleName()<<endl;

  return r;  //NB: it could be =NULL, as it is later 


}





RawScanResult* ArchRawScanResult::CreateRawScanResult(shared_ptr<RawScanResult> raw) {

  ArchRawScanResult tmp_createRaw(raw);
  return tmp_createRaw.CreateRawScanResult();

}






RawScanResult* ArchRawScanResult::CreateRawScanResult(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable, unsigned int cycle) {
  
  
  string Pers_Modulename;
  ModuleConfiguration m;
  //ScanPoints pts;
  TH2D* new_RawData_link0 = NULL;
  TH2D* new_RawData_link1 = NULL;


  ArchScanNames *new_names= new ArchScanNames(runNumber,moduleName,scanNumber, variable ); 

  string TH2Dlink0 = new_names->getTH2Dlink0();
  string TH2Dlink1 = new_names->getTH2Dlink1();
  string ScanPointsID = new_names->getScanPointsID() ;
  string vpointsID = new_names->getvpointsID();
  string vNEventsID = new_names->getvNEventsID();
  string vNErrorEventsID = new_names->getvNErrorEventsID(); 
  string filename = new_names->getfilename();
  //string objName = ;  //To be deleted
  string sVariable = new_names->getVariable(); //!!!!
  string moduleID = new_names->getModuleID(); 
  string testType  = new_names->getTestType(); 
  string runID = new_names->getRunID();
  string scanID = new_names->getScanID();
  string RODID = new_names->getRODID();
  string DCSID = new_names->getDCSID();
  string RawID = new_names->getRawID();
  string FitID = new_names->getFitID();
  string thresholdID = new_names->getThresholdID();




  if ( RawScanIsPersisted(scanNumber, runNumber, moduleName, variable) == 0 ) //To be modified: retrieve histo's and data from file
    { 
      
      cout << "...creating new RawScanResult obj from persistency" << endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      //string pers_
      int dot = moduleName.find('.');
      string Pers_ModuleID = moduleName.substr(0, dot).c_str();  
      Pers_Modulename = Pers_ModuleID + ".Persisted";
      
  

    } else {

      cout << "WARNING: the RawScanResult has NOT been persisted!!" <<endl;
      //Add at the end of the Unique ID, after the ModuleName, the string "Persisted"
      int dot = moduleName.find('.');
      string Pers_ModuleID = moduleName.substr(0, dot).c_str();   
      Pers_Modulename = Pers_ModuleID + ".Unpersisted";
      RawScanResult* r = NULL;   //NB: it's different from the previous two functions
      return r;                  //!!!!!!ERROR is r is never defined before!!!!!!
                                 //!!!!Needs Debugging!!!!!
    }

  
  /* Variable initialisation */


  
  /* Opening File */
  TFile *inspect_file = new TFile(filename.c_str(),"read");
  if (inspect_file->IsZombie() == true) {
    cout << "Problem in opening the file"<<endl; 
 
  }
  
  
  gDirectory->cd(runID.c_str());
  gDirectory->cd(moduleID.c_str());
  gDirectory->cd(testType.c_str());
  gDirectory->cd(sVariable.c_str());
  gDirectory->cd(scanID.c_str());
  /*

  //Retrieve Threshold
  TObject* pers_Threshold = gDirectory->FindObjectAny(thresholdID.c_str()); 
  TVectorD* vpers_Threshold = dynamic_cast<TVectorD*>(pers_Threshold);
  double *temp_vpers_Threshold = vpers_Threshold->GetElements();
  m.threshold = temp_vpers_Threshold[0];
*/
  
  /* ?????????? Retrieve ScanPoints...!!!!I know it's a very bad coding!!!! ??????? TO BE CHECKED ???????*/
  TObject* pers_vscanpoints = gDirectory->FindObjectAny(vpointsID.c_str()); 
  TVector* vpers_vscanpoints = dynamic_cast<TVector*>(pers_vscanpoints); 
  //TVector* vpers_vscanpoints = NULL;
  //vpers_vscanpoints->Read(vpointsID.c_str());
  //float *temp_vpers_vscanpoints = vpers_vscanpoints->GetElements(); 
  float *temp_vpers_vscanpoints = NULL;
  temp_vpers_vscanpoints = vpers_vscanpoints->GetElements();

  TObject* pers_vNEvents = gDirectory->FindObjectAny(vNEventsID.c_str());
  TVector* vpers_vNEvents = dynamic_cast<TVector*>(pers_vNEvents); 
  
  int NoElements = vpers_vNEvents->GetNoElements();  
  
  //!!!!Truncate float into int
  unsigned int temp_vpers_vNEvents[NoElements];
  unsigned int truncated_vpers_vNEvents;
  for (int i=0; i<NoElements; ++i) {
    truncated_vpers_vNEvents = int(*vpers_vNEvents->GetElements());
    //cout<< " I am here" <<endl;
    temp_vpers_vNEvents[i] = truncated_vpers_vNEvents;
  }

 
  TObject* pers_vNErrorEvents = gDirectory->FindObjectAny(vNErrorEventsID.c_str());
  TVector* vpers_vNErrorEvents = dynamic_cast<TVector*>(pers_vNErrorEvents); 
  //!!!!Truncate float into int
  unsigned int temp_vpers_vNErrorEvents[NoElements];
  unsigned int truncated_vpers_vNErrorEvents;
  for (int i=0; i<NoElements; ++i) {
    truncated_vpers_vNErrorEvents = int(*vpers_vNErrorEvents->GetElements());
    temp_vpers_vNErrorEvents[i] = truncated_vpers_vNErrorEvents;
  }


  ScanPoints *pts = new ScanPoints( NoElements, temp_vpers_vscanpoints ,temp_vpers_vNEvents ,temp_vpers_vNErrorEvents );
  /*??????????????????????????????????????????????????????????????????????????*/




  gDirectory->cd(RODID.c_str());
  gDirectory->cd(RawID.c_str());

 
  //Check if the two TH2D hist's have been persisted
  TObject* pers_RawTH2link0 = gDirectory->FindObjectAny(TH2Dlink0.c_str()); 
  //Retrieve new_TH2Dlink0

  new_RawData_link0 = dynamic_cast<TH2D*>(pers_RawTH2link0);

  
  TObject* pers_RawTH2link1 = gDirectory->FindObjectAny(TH2Dlink1.c_str()); 
  //Retrieve new_TH2Dlink1
  new_RawData_link1 = dynamic_cast<TH2D*>(pers_RawTH2link1);
  




  /*Creating RawScanResult object */
  ScanHeader s(scanNumber, runNumber, Pers_Modulename , variable);
  RawScanResult* r = new RawScanResult(s, m, *pts, *new_RawData_link0, *new_RawData_link1 ); 
  cout<< r->getHeader().getModuleName()<<endl;
  return r;


}






void ArchRawScanResult::SaveRawComment() {

  // Saving Txt Comments at the Fun level
  
  string filename = names->getfilename();
  string runID = names->getRunID();
  string moduleID = names->getModuleID();
  string testType = names->getTestType();
  string variable = names->getVariable();
  string scanID = names->getScanID();
  string RODID = names->getRODID();
  string RawID = names->getRawID();

  TFile *file = new TFile(filename.c_str(),"update");
  if (file->IsZombie() == true) {
    cout << "The ScanResult has NOT been saved in any file"<<endl; 
    return ;
  }
  /* Making RunNumber */
  TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str()); 
  if (!this_run) {
    //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
    this_run = file->mkdir(runID.c_str());
    //cout<<"New RunNumber Dir made "<<endl;
  }
  this_run->cd();  //make this_run the current directory

  /* Making moduleNumber   */
  
  TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
  if (!this_module) {
    //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
    this_module =gDirectory ->mkdir(moduleID.c_str());
  }
  this_module->cd();


  /* Making TestType   */
  TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
  if (!this_testType) {
    //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
    this_testType = gDirectory->mkdir(testType.c_str());
  }
  this_testType->cd();

  
  /* Making Variable   */
  TDirectory* this_variable = (TDirectory*) gDirectory->Get(variable.c_str());
  if (!this_variable) {
    //cout<<"This NEW test "<< variable <<" doesn't exist"<<endl;
    this_variable = gDirectory->mkdir(variable.c_str());
  }
  this_variable->cd();

  /* Making scanNumber   */
  TDirectory* this_scan = (TDirectory*) gDirectory->Get(scanID.c_str());
  if (!this_scan) {
    //cout<<"This NEW scan "<< scanID <<" doesn't exist"<<endl;
    this_scan =gDirectory ->mkdir(scanID.c_str());
  }
  this_scan->cd();   

  /* Making ROD   */ 
  TDirectory* this_ROD = (TDirectory*) this_scan->Get(RODID.c_str());
  if (!this_ROD) {
    //cout<<"This NEW ROD  doesn't exist"<<endl;
    this_ROD = this_scan->mkdir(RODID.c_str());
  }
  this_ROD->cd();
 
  /* Making ROD Raw    */
    TDirectory* this_raw = (TDirectory*) this_ROD->Get(RawID.c_str()); 
    if (!this_raw) {
      //cout<<"This NEW Raw Data  doesn't exist"<<endl;
      this_raw = this_ROD->mkdir(RawID.c_str());
    }
    this_raw->cd();  



  //...Opening TxtComment file 
  ifstream in;
  in.open(names->getTxtCommentRawName().c_str());

  int commentN;
    int sz = 1000; // Buffer size;
    char buf[sz];
    
    //char TxtComment[40];
    int nlines = 0;
    while (1) {
      in >> commentN;
      in.get(buf, sz);
      if (!in.good()) break;
      //cout<< " CommentN = "<< commentN << " String = "<< buf <<endl;
      TObjString Comment(buf);
      //sprintf(TxtComment,"TxtComment_%i",commentN);
      TObject* pers_TxtCommentN = gDirectory->FindObjectAny(names->getRawTxtComment(commentN).c_str());
      if (!pers_TxtCommentN) {
	//cout<<" TxtComment Never Persisted...persisting" <<endl;
	Comment.Write(names->getRawTxtComment(commentN).c_str());
      }
      nlines++;   
    }
    //printf(" found %d points \n",nlines);
    
    
    in.close();
    file->Close();

}

