#ifndef ArchFitScanResult_H
#define ArchFitScanResult_H

#include <vector>
#include <is/isinfo.h>
#include "SctData/ConfigurationVariable.h"
#include "SctData/FitScanResult.h"
#include "SctData/FitScanResultIOHelper.h"
#include "SctData/FitObject.h"
#include "Sct/SctNames.h"
#include "ArchScanResult.h"

class TFile;
class TDirectory;
class TObject;
class TSystem;
class TNamed;
class TString;
class TObjString;
class TH1D;
class TH2;


using namespace SctData;
using namespace Sct;
using namespace boost;

class ArchFitScanResult: public ArchScanResult {
  private:
    
  //FitScanResultIOHelper Archfit;   ?????

    shared_ptr<const FitScanResult> theFit;
    static bool inMap;

    ArchFitScanResult(shared_ptr<const FitScanResult> fit);

    
  public:
    
    ArchFitScanResult(); 

    virtual shared_ptr<ArchScanResult> clone(shared_ptr<ScanResult> scan) {
                                   shared_ptr<FitScanResult> fit = dynamic_pointer_cast<FitScanResult>(scan);
                                   return shared_ptr<ArchScanResult>(new ArchFitScanResult(fit));
    } 
    
    ~ArchFitScanResult();

    void SetFitScan(shared_ptr<const FitScanResult> );

    void SaveFitScan();
    void SaveFitScan(shared_ptr<const FitScanResult> );
    void Save();
    void Save(shared_ptr<const FitScanResult> );
    bool FitScanIsPersisted(); 
    bool FitScanIsPersisted(shared_ptr<FitScanResult> );
    bool FitScanIsPersisted(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable);
    //void DeletePersFitObj(FitScanResult& );  //!!Problem  
    //void DeletePersFitObj();                 //!!Problem
    FitScanResult* CreateFitScanResult();
    FitScanResult* CreateFitScanResult(shared_ptr<FitScanResult>);
    FitScanResult* CreateFitScanResult(long scanNumber, long runNumber, string moduleName, const ConfigurationVariable& variable);


    void SaveFitComment();
 


};


 


#endif
