/*
 * PlotterManager.java
 *
 * Created on 03 November 2003, 16:02
 */

package TestGUI.plotter.jasimp;

import TestGUI.plotter.Plotter;
import java.util.*;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import hep.aida.*;
import hep.aida.ref.plotter.PlotterUtilities;
import SctData.*;

/**
 *
 * @author  palmer
 */
public class PlotterManager extends TestGUI.plotter.PlotterManager {
    
    /** Creates a new instance of PlotterManager */
    public static PlotterManager instance() {
        if (instance == null) instance = new PlotterManager();
        return instance;
    }
    
    public JPanel getPlotPanel() {
        if (panel == null) {
            panel = new JPanel();

            // Now embed the plotter
            panel.add(PlotterUtilities.componentForPlotter(getIPlotter()), BorderLayout.CENTER);
        }
        
        return panel;
    }
    
    public Plotter getPlotter(Class c) {
        return (Plotter)map.get(c);
    }
    
    public void setPlotter(Class c, Plotter p) {
        map.put(c, p);
    }
    
    public void plot(Object ob) {
        getIPlotter().clearRegions();
        getPlotter(ob.getClass()).plot(ob, this);
    }     

    public IPlotter getIPlotter() {
        if (iplotter == null) {
            IAnalysisFactory af = IAnalysisFactory.create();
            ITree tree = af.createTreeFactory().create();            

            // Create an IPlotter 
            iplotter = af.createPlotterFactory().create();               
        }
        
        return iplotter;
    }    
    
    /** Creates a new instance of PlotterMap */
    private PlotterManager() {
        //Add everything to the map
        setPlotter(RawScanResult.class, new RawScanResultPlotter());
    }
    
   
    private JPanel panel;
    private IPlotter iplotter;
    private HashMap map = new HashMap();
    private static PlotterManager instance;
}
