/**
 * A Test GUI to show that using IPC/IS/OH is possible from Java and what you can do with it!
 * The GUI also has scripting support thanks to IBM's Bean Scripting Framework and histogram plotting
 * capabilities thanks to JAIDA.
 */
package TestGUI;

import javax.swing.*;
import is.*;
import SctData.*;
import Sct.Version;
import GuiComponents.System.*;
import SctTestApi.*;

/**
 *
 * @author Matthew Palmer
 */
public class MyJPanel extends javax.swing.JPanel {
    protected static JTextArea taOutput;
    
    /** Creates new form MyJPanel */
    public MyJPanel() {
        initComponents();
        myInitComponents();      
    }
    
    private void exit() {
        pIS.close();
        pMRS.close();
        pCC.close();
        System.exit(0); 
    }
    
    private void myInitComponents() {
        taOutput = new JTextArea() {
            public void append(String str) {
                super.append(str);
                setCaretPosition(getText().length());
            }
        };
        
        taOutput.setEditable(false);
        taOutput.setBorder(new javax.swing.border.EtchedBorder());
        jScrollPane1.setViewportView(taOutput);
        
        si = SystemInterface.getInstance();
        is = ISInterface.getInstance();
        pIS = new ISPanel(taOutput);
        pMRS = new MRSPanel(taOutput);
        pCC = new CalibrationControllerPanel(taOutput);
        scripting = new ScriptingPanel(this);
        
        this.tpTabs.insertTab("IS", null, pIS, "IS Servers in Partition SCT", 0);        
        this.tpTabs.insertTab("MRS", null, pMRS, "MRS Messages for Partition SCT", 1);
        this.tpTabs.insertTab("CalibrationController", null, pCC, "Interface to Calibration Controller", 2);
        this.tpTabs.addTab("Scripting", null, scripting, "Gives command line access in a choice of languages");
    }
    
    public static JTextArea getMessageArea() {
        return taOutput;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        
        jSplitPane1 = new javax.swing.JSplitPane();
        tpTabs = new javax.swing.JTabbedPane();
        pAPI = new javax.swing.JPanel();
        bRefresh = new javax.swing.JButton();
        bPipeline = new javax.swing.JButton();
        bTrim = new javax.swing.JButton();
        bStobe = new javax.swing.JButton();
        bApiPing = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        bNoise = new javax.swing.JButton();
        b3Gain = new javax.swing.JButton();
        bResponse = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        bBypass = new javax.swing.JButton();
        bTimeWalk = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        lOutput = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel2 = new javax.swing.JPanel();
        bAbout = new javax.swing.JButton();
        bGC = new javax.swing.JButton();
        bExit = new javax.swing.JButton();
        
        setLayout(new java.awt.GridBagLayout());
        
        jSplitPane1.setDividerLocation(400);
        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        pAPI.setLayout(new java.awt.GridBagLayout());
        
        pAPI.setName("API");
        bRefresh.setText("Refresh");
        bRefresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bRefreshActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bRefresh, gridBagConstraints);
        
        bPipeline.setText("Pipeline Test");
        bPipeline.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bPipelineActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bPipeline, gridBagConstraints);
        
        bTrim.setText("Trim Range");
        bTrim.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bTrimActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bTrim, gridBagConstraints);
        
        bStobe.setText("Strobe Delay");
        bStobe.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bStobeActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bStobe, gridBagConstraints);
        
        bApiPing.setText("Ping");
        bApiPing.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bApiPingActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bApiPing, gridBagConstraints);
        
        jSeparator1.setOrientation(javax.swing.SwingConstants.VERTICAL);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(jSeparator1, gridBagConstraints);
        
        bNoise.setText("Noise");
        bNoise.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bNoiseActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bNoise, gridBagConstraints);
        
        b3Gain.setText("3 Point Gain");
        b3Gain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                b3GainActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(b3Gain, gridBagConstraints);
        
        bResponse.setText("Response Curve");
        bResponse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bResponseActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bResponse, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(jLabel1, gridBagConstraints);
        
        bBypass.setText("Full Bypass");
        bBypass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBypassActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bBypass, gridBagConstraints);
        
        bTimeWalk.setText("Time Walk");
        bTimeWalk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bTimeWalkActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        pAPI.add(bTimeWalk, gridBagConstraints);
        
        tpTabs.addTab("API", null, pAPI, "Controls the test SCTAPI interface");
        
        jSplitPane1.setTopComponent(tpTabs);
        
        jPanel1.setLayout(new java.awt.BorderLayout());
        
        lOutput.setText("Output");
        jPanel1.add(lOutput, java.awt.BorderLayout.NORTH);
        
        jPanel1.add(jScrollPane1, java.awt.BorderLayout.CENTER);
        
        jSplitPane1.setBottomComponent(jPanel1);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jSplitPane1, gridBagConstraints);
        
        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));
        
        bAbout.setText("About");
        bAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bAboutActionPerformed(evt);
            }
        });
        
        jPanel2.add(bAbout);
        
        bGC.setText("GC");
        bGC.setMaximumSize(new java.awt.Dimension(57, 32));
        bGC.setMinimumSize(new java.awt.Dimension(57, 32));
        bGC.setPreferredSize(new java.awt.Dimension(57, 32));
        bGC.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bGCActionPerformed(evt);
            }
        });
        
        jPanel2.add(bGC);
        
        bExit.setText("Exit");
        bExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bExitActionPerformed(evt);
            }
        });
        
        jPanel2.add(bExit);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jPanel2, gridBagConstraints);
        
    }//GEN-END:initComponents

    private void bTimeWalkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bTimeWalkActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.timeWalk();
                taOutput.append("Requesting SctTest do a timewalk scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a timewalk scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bTimeWalkActionPerformed

    private void bBypassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBypassActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.fullBypass();
                taOutput.append("Requesting SctTest do a full bypass scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a full bypass scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bBypassActionPerformed

    private void bAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAboutActionPerformed
        String version = Version.instance.getAllInformation();
        String s = "TestGUI is a simple user interface for developers and is also used as a testbed for new developments.";
        s += "\nIt comes with no instructions or warranties, but may be useful for some purposes!";
        s += "\nTestGUI Author: Matthew Palmer.";
        s += "\nSctDaqRod Authors: Alan Barr, Bruce Gallop, Matthew Palmer, Dave Robinson and Alexander Tricoli";
        s += "\n\n" + version;
        JOptionPane.showMessageDialog(this, s, "About TestGUI", JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_bAboutActionPerformed

    private void bRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRefreshActionPerformed
        si.refresh();
    }//GEN-LAST:event_bRefreshActionPerformed

    private void bPipelineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bPipelineActionPerformed
	HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.pipeline();
                taOutput.append("Requesting SctTest do a pipeline scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a pipeline scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bPipelineActionPerformed

    private void bTrimActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bTrimActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.trim();
                taOutput.append("Requesting sct_api_server do a trim range scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a trim scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SCTTestAPI not present\n");
        }
    }//GEN-LAST:event_bTrimActionPerformed

    private void bStobeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bStobeActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.strobeDelay();
                taOutput.append("Requesting SctTest do a strobe delay scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a strobe delay scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bStobeActionPerformed

    private void bApiPingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bApiPingActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            //taOutput.append(api.ping("") + "\n");
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bApiPingActionPerformed

    private void bNoiseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bNoiseActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.noiseOccupancy();
                taOutput.append("Requesting SctTest do a noise scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a noise occupancy scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bNoiseActionPerformed

    private void b3GainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_b3GainActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.threePointGain();
                taOutput.append("Requesting SctTest do a 3 pt gain scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a three point gain scan: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_b3GainActionPerformed

    private void bResponseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bResponseActionPerformed
        HighLevelApi api = si.getTestHighLevelApi();
        if (api != null) {   
            try {
                api.responseCurve();
                taOutput.append("Requesting SctTest do a response curve scan\n");
            } catch (SctTestApi.NoDataException nde) {
                taOutput.append("Failed to do a response curve: " + nde.getMessage());
            }
        } else {
            taOutput.append("SctTest not present\n");
        }
    }//GEN-LAST:event_bResponseActionPerformed

    private void bGCActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bGCActionPerformed
        Runtime r = Runtime.getRuntime();
        long freeMem = r.freeMemory();        
        long maxMem = r.maxMemory();
        long totalMem = r.totalMemory();
        taOutput.append("Total Mem: " + totalMem/1024. + ", Max Mem:" + maxMem/1024. + " , Free Mem: " + freeMem/1024.+ "\n" );
        r.gc();
        try {
            Thread.sleep(500);
        } catch (InterruptedException ie) {}
        r.gc();
        freeMem = r.freeMemory();
        maxMem = r.maxMemory();
        totalMem = r.totalMemory();
        taOutput.append("Total Mem: " + totalMem/1024. + ", Max Mem:" + maxMem/1024. + " , Free Mem: " + freeMem/1024. + "\n" );
    }//GEN-LAST:event_bGCActionPerformed
        
    //For now, just quit
    private void bExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bExitActionPerformed
        exit();
    }//GEN-LAST:event_bExitActionPerformed
         
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton b3Gain;
    private javax.swing.JButton bAbout;
    private javax.swing.JButton bApiPing;
    private javax.swing.JButton bBypass;
    private javax.swing.JButton bExit;
    private javax.swing.JButton bGC;
    private javax.swing.JButton bNoise;
    private javax.swing.JButton bPipeline;
    private javax.swing.JButton bRefresh;
    private javax.swing.JButton bResponse;
    private javax.swing.JButton bStobe;
    private javax.swing.JButton bTimeWalk;
    private javax.swing.JButton bTrim;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JLabel lOutput;
    private javax.swing.JPanel pAPI;
    private javax.swing.JTabbedPane tpTabs;
    // End of variables declaration//GEN-END:variables
    private ISPanel pIS;
    private MRSPanel pMRS;
    private CalibrationControllerPanel pCC;
    SystemInterface si;
    ISInterface is;
    ScriptingPanel scripting;
}
