#include "Sct/IS/IOManagerIS.h"
#include "SctData/RawScanResult.h"
#include "SctData/ScanPoints.h"
#include "SctData/ModuleConfiguration.h"
#include <TH2.h>

using namespace Sct;
using namespace Sct::IS;
using namespace SctData;
using namespace std;
using namespace boost;

class CheckRaw {
public:
    unsigned int runNumber;
    unsigned int scanNumber;
    string moduleName;
    unsigned char groupID;
    float chip5CalFactor;
    unsigned char chip4Target;
    unsigned char chip11Threshold;
    unsigned char chip0Chan0Trim;
    unsigned int nPoints;
    double point0;
    double bin00;
    double bin4930;
    int exitCode;    
    
    CheckRaw() {
	exitCode = 0;
    }
    
    void compare(string name) {
	shared_ptr<Serializable> s = IOManagerIS::instance().read(name, 0);
	cout << name << ": " << s->getClassName() << endl;
	RawScanResult& r = *dynamic_pointer_cast<RawScanResult>(s);
	
	if (r.getHeader().getRunNumber() != runNumber) {
	    cout << "RunNumber not equal. Got: " << r.getHeader().getRunNumber() << " expected: " << runNumber << endl;
	    ++exitCode;
	}
	
	if (r.getHeader().getScanNumber() != scanNumber) {
	    cout << "ScanNumber not equal. Got: " << r.getHeader().getScanNumber() << " expected: " << scanNumber << endl;
	    ++exitCode;
	}

	if (r.getHeader().getModuleName() != moduleName) {
	    cout << "ModuleName not equal. Got: " << r.getHeader().getModuleName() << " expected: " << moduleName << endl;
	    ++exitCode;
	}

	if (r.getConfiguration().getGroupId() != groupID) {
	    cout << "GroupId not equal. Got: " << (int)r.getConfiguration().getGroupId() << " expected: " << (int)groupID << endl;
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(5).getCalFactor() != chip5CalFactor) {
	    cout << "chip5CalFactor not equal. Got: " << r.getConfiguration().getChipConfiguration(5).getCalFactor() << " expected: " << chip5CalFactor << endl;
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(4).getTrimTarget() != chip4Target) {
	    cout << "chip4Target not equal. Got: " << (int)r.getConfiguration().getChipConfiguration(4).getTrimTarget() << " expected: " << (int)chip4Target << endl;
	    ++exitCode;    
	}
	if (r.getConfiguration().getChipConfiguration(11).getThreshold() != chip11Threshold) {
	    cout << "chip11Threshold not equal. Got: " << (int)r.getConfiguration().getChipConfiguration(11).getThreshold() << " expected: " << (int)chip11Threshold << endl;
	    ++exitCode;    
	}	
	if (r.getConfiguration().getChipConfiguration(0).getTrim(0) != chip0Chan0Trim) {
	    cout << "chip0Chan0Trim not equal. Got: " << (int)r.getConfiguration().getChipConfiguration(0).getTrim(0) << " expected: " << (int)chip0Chan0Trim << endl;
	    ++exitCode;    
	}
	
	if (r.getPoints().getNPoints() != nPoints) {
	    cout << "nPoints not equal. Got: " << r.getPoints().getNPoints() << " expected: " << nPoints << endl;
	    ++exitCode;        
	}
	if (r.getPoints().getPoint(0) != point0) {
	    cout << "point0 not equal. Got: " << r.getPoints().getPoint(0) << " expected: " << point0 << endl;
	    ++exitCode;        
	}
	
	if (fabs(r.getScanData(0).GetBinContent(1, 1) - bin00) > 0.1) {
	    cout << "bin00 not equal. Got: " << r.getScanData(0).GetBinContent(1, 1) << " expected: " << bin00 << endl;
	    ++exitCode; 
	}
	if (fabs(r.getScanData(1).GetBinContent(50, 31) - bin4930) > 0.1) {
	    cout << "bin4930 not equal. Got: " << r.getScanData(1).GetBinContent(50, 31) << " expected: " << bin4930 << endl;
	    ++exitCode; 
	}
	cout << endl;
    }
};

int main(int argc, char** argv) {
    CheckRaw cr;
    try {
	cr.runNumber = 1047;
	cr.scanNumber = 6;
	cr.moduleName = "20220330200015";
	cr.groupID = 0;
	cr.chip5CalFactor = 1.0f;
	cr.chip4Target = 38;
	cr.chip11Threshold = 38;
	cr.chip0Chan0Trim = 2;	
	cr.nPoints = 57;
	cr.point0 = 60;	
	cr.bin00 = 1000;	
	cr.bin4930 = 209;
	cr.compare("EventData.SctData::RawScanResult.1047.6.20220330200015");
	
	cr.runNumber = 1048;
	cr.scanNumber = 16;
	cr.moduleName = "20220330200015";
	cr.groupID = 0;
	cr.chip5CalFactor = 1.0f;
	cr.chip4Target = 38;
	cr.chip11Threshold = 38;
	cr.chip0Chan0Trim = 2;	
	cr.nPoints = 57;
	cr.point0 = 60;	
	cr.bin00 = 1000;	
	cr.bin4930 = 209;
	cr.compare("EventData.SctData::RawScanResult.1048.16.20220330200015");
	
	/*
	cr.runNumber = 1;
	cr.scanNumber = 1;
	cr.moduleName = "20220170100053";
	cr.groupID = 0;
	cr.chip5CalFactor = 1.0f;
	cr.chip4Target = 0;
	cr.chip11Threshold = 40;
	cr.chip0Chan0Trim = 7;	
	cr.nPoints = 64;
	cr.point0 = 0;	
	cr.bin00 = 0;	
	cr.bin4930 = 200;
	cr.compare("EventData.SctData::RawScanResult.1.1.20220170100053");
	
	
	cr.runNumber = 1;
	cr.scanNumber = 3;
	cr.moduleName = "20220170100053";
	cr.groupID = 0;
	cr.chip5CalFactor = 1.0f;
	cr.chip4Target = 0;
	cr.chip11Threshold = 40;
	cr.chip0Chan0Trim = 7;	
	cr.nPoints = 64;
	cr.point0 = 0;	
	cr.bin00 = 0;	
	cr.bin4930 = 1000;
	cr.compare("EventData.SctData::RawScanResult.1.3.20220170100053");
	
	
	cr.runNumber = 1;
	cr.scanNumber = 4;
	cr.moduleName = "20220170100028";
	cr.groupID = 2;
	cr.chip5CalFactor = 1.0f;
	cr.chip4Target = 0;
	cr.chip11Threshold = 40;
	cr.chip0Chan0Trim = 4;	
	cr.nPoints = 64;
	cr.point0 = 0;	
	cr.bin00 = 0;	
	cr.bin4930 = 995;
	cr.compare("EventData.SctData::RawScanResult.1.4.20220170100028");*/
	
    } catch (Exception& e) {
	e.sendToMrs(MRS_ERROR);
	return -2;
    }	
}
