#ifndef TESTFILEUTIL_H
#define TESTFILEUTIL_H

#include "SctData/DefectList.h"
#include <istream>

using namespace std;
using namespace SctData;

//Simple file to help reading in the files produced by getDBfiles
//All methods should be called in order;
class TestFileUtil {
public:
    /**
      Reads from the beginning to the PASS/FAIL/PROBLEM field
      */
    static int getPass(istream& in);
    
    /**
      Skips unnecessary stuff - after this call, do 
      in >> chipName >> val1 >> val2 etc to read in values
      returns the SCTDAQVersion
      */
    static float skipHeader(istream& in);
    
    /**
      Creates a DefectList of all the defects
      */
    static DefectList readDefects(istream& in);
};


int TestFileUtil::getPass(istream& in) {
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    string pass;
    in >> pass;
    in.ignore(1024, '\n'); 	//Make sure we are at the start of the next line
    if (pass == "PASS") return 1;
    if (pass == "PROBLEM") return 2;
    return 0;
}

float TestFileUtil::skipHeader(istream& in) {
    float SCTDAQVersion = 0;
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.width(15);
    string text;
    in >> text >> SCTDAQVersion;
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    in.ignore(1024, '\n');
    return SCTDAQVersion;
}
    
DefectList TestFileUtil::readDefects(istream& in) {
    return DefectList();
}

#endif //TESTFILEUTIL_H
