#ifndef SCTDATADISPLAY_EXCEPTIONS_H
#define SCTDATADISPLAY_EXCEPTIONS_H

//This file contains exceptions for the data display stuff

#include "Sct/Exception.h"

namespace SctDataDisplay {
    
    
class NoDisplayerException : Sct::Exception {
public:  
    /**
      Creates an Exception with message msg and no cause
      */
    NoDisplayerException(const string& msg, const string& file, int line) throw();
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    NoDisplayerException(Throwable& cause, const string& file, int line) throw();
    
    /**
      Creates an Exception with a message and a cause
      */
    NoDisplayerException(const string& msg, Throwable& cause, const string& file, int line) throw();
    
protected:
    NoDisplayerException() throw() {}
};	
	
    
}

#endif //SCTDATADISPLAY_EXCEPTIONS_H
