#ifndef SCTDATADISPLAY_DISPLAYMANAGER_H
#define SCTDATADISPLAY_DISPLAYMANAGER_H

#include <boost/shared_ptr.hpp>
#include <map>
#include <string>
#include <vector>

using std::map;
using std::vector;
using std::string;
using boost::shared_ptr;

namespace Sct {
    class Serializable;
}

namespace SctDataDisplay {
    
class Displayer;
class GenericDisplayer;
class DisplayInfo;
class DisplayData;
 
/**
  Entrance point - handles a mpa between class names and Displayers
  @author Matthew Palmer
  */
class DisplayManager {
public:
    /**
      Get the DisplayManager instance.
      */
    static DisplayManager& instance();
    
    /**
      Add a Displayer to the map.  Returns true if added.
      Will not replace a pre-exisiting Displayer.
      */
    static bool addToMap(string className, shared_ptr<Displayer> displayer);
    
    /**
      Display an object.  Forwards the call to the appropriate Displayer.
      @throws NoDisplayerException if there is no appropriate Displayer.
      */
    static shared_ptr<DisplayData> display(shared_ptr<const Sct::Serializable> ob, const DisplayInfo& info, std::ostream& os);
    

    /**
      Adds a GenericDisplayer to the list.  These will be used if there is no
      specific Displayer available
      @note nothrow
      */
    static bool addGeneric(shared_ptr<GenericDisplayer> generic);
    
    /** 
      Returns true if the manager is in batch mode
    */
    static bool batchMode();
    /**
       Allows one to set the displayer in batch mode, so that all output goes to file.
     */
    static void setBatchMode(bool b=true);
    /**
     * Write canvases to gif files
     */
    static void OutputCanvases();
private:
    DisplayManager();
    map<string, shared_ptr<Displayer> > displayerMap;
    vector<shared_ptr<GenericDisplayer> > genericList;
    bool m_batchMode;
};

}

#endif //SCTDATADISPLAY_DISPLAYMANAGER_H
