#include <ipc/object.h>
#include <ipc/server.h>

#include <boost/date_time/posix_time/posix_time.hpp>
#include <boost/lexical_cast.hpp>
#include "SctApiScan_Test.h"
#include "../SctApiServer.h"
#include "SctApi/SctApi.h"
#include "sctConf/configXMLImpl.h"
#include <boost/test/unit_test.hpp>
#include <iostream>

std::auto_ptr<IPCServer> ipcServer;

using boost::unit_test_framework::test_suite;
using namespace boost::posix_time;
using namespace boost::gregorian;

namespace SctApi {
  namespace Tests {
    void testGetScan() {
      IPCPartition p("SCT");
      ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

      std::auto_ptr<SctApi::SctApi> ob(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new ConfigurationXMLImpl)));

      std::auto_ptr<SctApiServer> api(new SctApiServer(*ob, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

      Sct_SctApiStatus status;
      Sct_SctApi_T_Scan *newScan = api->createScan(&status);

      BOOST_CHECK(newScan != 0); 
    }

    void testGetScanTrigger() {
      IPCPartition p("SCT");
      ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

      std::auto_ptr<SctApi::SctApi> ob(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new ConfigurationXMLImpl)));

      std::auto_ptr<SctApiServer> api(new SctApiServer(*ob, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

      Sct_SctApiStatus status;
      status.returnCode = 0;
      Sct_SctApi_T_Scan *newScan = api->createScan(&status);
      if(status.returnCode != 0) {
        throw SctApiException("Bad return code from createScan " + boost::lexical_cast<std::string>((int)status.returnCode));
      }

      BOOST_CHECK(newScan != 0); 

      Sct_SctApi_T_Trigger *newTrigger = newScan->getTrigger1(&status);
      if(status.returnCode != 0) {
        throw SctApiException("Bad return code from getTrigger1 " + boost::lexical_cast<std::string>((int)status.returnCode));
      }

      BOOST_CHECK(newTrigger != 0); 

      newTrigger->singleL1A(&status);
      if(status.returnCode != 0) {
        throw SctApiException("Bad return code from singleL1A");
      }
    }

    void testGetDefaultScan() {
      IPCPartition p("SCT");
      ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

      std::auto_ptr<SctApi::SctApi> ob(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new ConfigurationXMLImpl)));

      std::auto_ptr<SctApiServer> api(new SctApiServer(*ob, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

      Sct_SctApiStatus status;
      Sct_SctApi_T_Scan *newScan = api->getDefaultScan(&status);

      BOOST_CHECK(newScan != 0); 
    }

    void testModifyDefaultScan() {
      IPCPartition p("SCT");
      ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

      std::auto_ptr<SctApi::SctApi> ob(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new ConfigurationXMLImpl)));

      std::auto_ptr<SctApiServer> api(new SctApiServer(*ob, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

      Sct_SctApiStatus status;
      Sct_SctApi_T_Scan *firstDefaultScan = api->getDefaultScan(&status);
      BOOST_CHECK(firstDefaultScan != 0); 
      firstDefaultScan->setOption(&status, Sct_SctApi_T_Scan_ScanOptions_debug, 15);

      Sct_SctApi_T_Scan *secondDefaultScan = api->getDefaultScan(&status);
      BOOST_CHECK(secondDefaultScan != 0); 

      int defValue1 = firstDefaultScan->getOption(&status, Sct_SctApi_T_Scan_ScanOptions_debug);
      int defValue2 = secondDefaultScan->getOption(&status, Sct_SctApi_T_Scan_ScanOptions_debug);

      BOOST_CHECK(defValue1 == 15); 
      BOOST_CHECK(defValue2 == 15); 
    }

    void testCreateIsDefault() {
      IPCPartition p("SCT");
      ipcServer.reset(new IPCServer(Sct_SctApi_C_SctApi_serverName, p));

      std::auto_ptr<SctApi::SctApi> ob(new SctApi::SctApi(boost::shared_ptr<SctConfiguration::Configuration>(new ConfigurationXMLImpl)));

      std::auto_ptr<SctApiServer> api(new SctApiServer(*ob, Sct_SctApi_C_SctApi_instanceName, ipcServer.get()));

      Sct_SctApiStatus status;
      Sct_SctApi_T_Scan *defScan = api->getDefaultScan(&status);

      BOOST_CHECK(defScan != 0); 

      defScan->setOption(&status, Sct_SctApi_T_Scan_ScanOptions_debug, 15);

      Sct_SctApi_T_Scan *scan = api->createScan(&status);

      BOOST_CHECK(scan != 0); 

      int defValue = scan->getOption(&status, Sct_SctApi_T_Scan_ScanOptions_debug);

      BOOST_CHECK(defValue == 15); 
    }

    SctApiScan_Test::SctApiScan_Test() {
	add(BOOST_TEST_CASE(&testGetScan));
	add(BOOST_TEST_CASE(&testGetScanTrigger));
        add(BOOST_TEST_CASE(&testGetDefaultScan));
        add(BOOST_TEST_CASE(&testModifyDefaultScan));
        //        add(BOOST_TEST_CASE(&testCreateIsDefault));
    }	
}
}
