#include <iostream>
#include <string>

#include "utility.h"

#include "primParams.h"

#include "SctApi.h" // For Exception...!

using namespace std;

namespace SctApi {
  namespace Utility {
    void printMemoryBlock(ostream &os, unsigned long *mem, unsigned long words, int wordsPerLine, int level) 
    {
      unsigned int lines = words/wordsPerLine;
      int skipping = 0;

      os.fill('0');

      os << hex;
      for(unsigned int i=0; i<lines; i++) {
        int val = 0;
        for(int j=0; j<wordsPerLine; j++) {
          val+=mem[i*wordsPerLine+j];
        }
        if(val == 0) {
          if(!skipping) 
            os << string("        ", 0, level) << ".";
          skipping++;
        } else {
          if(skipping) os << " Skipped " << dec << skipping << hex << " blank lines\n";
          skipping = 0;

          os << string("        ", 0, level);
          for(int j=0; j<wordsPerLine; j++) {
            os.fill('0');
            os.width(8);
            os << mem[i*wordsPerLine+j] << " ";
          }
          os << endl;
        }
      }
      if(skipping) os << " Skipped " << dec << skipping << hex << " blank lines\n";
      if(lines*wordsPerLine < words) {
        os << string("        ", 0, level);
        for(unsigned int i=lines*wordsPerLine; i<words; i++) {
          os.fill('0');
          os.width(8);
          os << mem[i] << " ";
        }
        os << endl;
      }
      os.fill(' ');

      os << dec;
    }

    int translateBank(BankType bank) {
      int realBank;
      switch(bank) {
#ifdef PHYSICS_MODULE_CONFIG
      case SCTAPI_BANK_PHYSICS:
        realBank = PHYSICS_MODULE_CONFIG;
        break;
      case SCTAPI_BANK_SCAN:
        realBank = SCAN_MODULE_CONFIG;
        break;
      case SCTAPI_BANK_CALIBRATION:
        realBank = SPARE_MODULE_CONFIG;
        break;
#else
      case SCTAPI_BANK_PHYSICS:
        realBank = INIT_MODULE_CONFIG;
        break;
      case SCTAPI_BANK_SCAN:
        realBank = WORK_MODULE_CONFIG;
        break;
      case SCTAPI_BANK_CALIBRATION:
        realBank = SPARE_MODULE_CONFIG;
        break;
#endif
      default:
        std::cout << "translateBank: Invalid bank specification " << bank << endl;
        throw SctApiException("Invalid bank specification");
      }
      return realBank;
    }
  }
}
