#define USELIBRARY

#include <iostream>

#include "../TApi.h"

int main() {

  std::set_terminate(__gnu_cxx::__verbose_terminate_handler);


  TScanDef synch;

  synch.trigsPerBurst = 10;

  synch.configure(9, 0, 128, 1);

  synch.trigSequence.singleL1A();

  synch.print();

  synch.distSlave = 0;
  synch.tim = 1;

  // Start TApi
  TApi tapi;

  tapi.initialiseAll(0);

  tapi.setDebugOption("save_histogram");

  tapi.sendABCDModules(0);

  tapi.probe(0, 0, 0);

  tapi.modifyABCDVar(11, 1.0);
  tapi.modifyABCDVar(13, 0.0);
  tapi.modifyABCDVar(14, 1.0);     // Send mask bit
  tapi.doScan(synch);

  tapi.awaitScan();

  std::cout << "TIM trigs: Scan complete\n";
}
