#include "ModuleDataFile.h"
#include "Sct/IoExceptions.h"
#include "Sct/Env.h"

namespace SctTest {
ModuleDataFile::ModuleDataFile(string fileName) : file(fileName.c_str()) {
    if (!file.is_open()) throw Sct::FileException(fileName, "Cannot open file", __FILE__, __LINE__);
}

bool ModuleDataFile::hasMoreRecords() {
    if (file.eof() || !file.is_open()) return false;
    return true;
}

ModuleDataRecord ModuleDataFile::getNextRecord() {
    ModuleDataRecord r;
    file >> r.serialNumber >> r.testName >> r.dataPath >> r.runNumber >> r.scanNumber >> std::ws;
    r.dataPath = Sct::Env::substituteVariables(r.dataPath);
    return r;
}

}
