#include "Sct/Exception.h"
//#include "SctData/FitFunctions.h"
#include "SctData/CachedFunction1D.h"
#include "TMath.h"
#include <iomanip>
#include <iostream>
#include <ctime>

using namespace std;

int main(int argc, char** argv){
    Sct::setExceptionHandlers(argv[0]);
    SctData::CachedFunction1D myErf(-4., 4., 0.0001, &::erf );

    unsigned int count = 0;
    time_t start = time(0);
    for(unsigned int i=0; i<100000; ++i){
	for (double x=-5; x<5; x+=0.000133){
	    myErf.eval(x);
	    ++count;
	}
    }
    time_t end = time(0);
    double t = difftime(end, start);
    
    cout << "Time for " << count << " evals of cached erf from -5 to 5 was: " <<  t << " secs (" << t/count * 1e7 << " secs per 1e7 evals)"  << endl;

    
    count = 0;
    start = time(0);
    for(unsigned int i=0; i<1000; ++i){
	for (double x=-5; x<5; x+=0.000133){
	    ::erf(x);
	    ++count;
	}
    }
    end = time(0);
    t = difftime(end, start);
    
    cout << "Time for " << count << " evals of non-cached erf from -5 to 5 was: " <<  t << " secs (" << t/count * 1e7 << " secs per 1e7 evals)"  << endl;
    
    
    double maxerr=0.;
    double maxx=0;
    for (double x=-6; x<6; x+=0.00000133){
        double err= ::erf(x) - myErf.eval(x);
	if (err<0) err=-err;
	if (err>maxerr) {
	    maxerr=err;
	    maxx = x;
	}
    }
    cout << "Max error = "<<setprecision(12) << maxerr <<  " at: x= " << 
	maxx << "  ::erf: " << erf(maxx) << "  cached erf: " << myErf.eval(maxx) << endl;
}
