#ifndef MVFROMTRIMTARGETTHRESHOLDVARIABLE_H
#define MVFROMTRIMTARGETTHRESHOLDVARIABLE_H

#include <string>
#include "Sct/round.h"
#include "ThresholdVariable.h"

using std::string;
using namespace Sct;

namespace SctData {
    
class mVfromTrimTargetThresholdVariable : public ThresholdVariable {
public:
    static const mVfromTrimTargetThresholdVariable& instance() throw();
    
    virtual double getLinkActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int chip) const throw();
    virtual double getChannelActualPoint(double logicalPt, const ModuleConfiguration& config, unsigned int channel) const throw();    
    
    virtual double getLinkLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int link) const throw();
    virtual double getChipLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int chip) const throw();    
    virtual double getChannelLogicalPoint(double actualPt, const ModuleConfiguration& config, unsigned int channel) const throw();   
     
private:
    mVfromTrimTargetThresholdVariable();
    unsigned char getActualPoint(double logicalPt) const throw();
    double getLogicalPoint(unsigned char actualPt) const throw();
};

///To get mV from DAC, multiply by 2.5
inline unsigned char mVfromTrimTargetThresholdVariable::getActualPoint(double logicalPt) const throw() {    
    return roundToUChar(logicalPt/2.5);
}

inline double mVfromTrimTargetThresholdVariable::getLogicalPoint(unsigned char actualPt) const throw() {
    return 2.5 * actualPt;
}


}

#endif //#ifndef MVFROMTRIMTARGETTHRESHOLDVARIABLE_H
