#ifndef SCTDATA_UNIQUEID_H
#define SCTDATA_UNIQUEID_H

#include <string>

using std::string;

namespace SctData {

/**
This is a simple class to facilitate constructing and parsing uniqueIDs.
All classes in this package should use this type of uniqueID.

@author Matthew Palmer
*/
class UniqueID {
public:
    /**
    Constructs from a string envoded uniqueID.
    throws InvalidArgumentError if the format of uniqueID is not correct
    */
    UniqueID(string uniqueID);

    /**
    Constructs a UniqueID from its constituents.
    Does not throw
    */
    UniqueID(unsigned int runNumber, unsigned int scanNumber, string module);

    /**
    Returns the unique ID
    Does not throw
    */
    string getUniqueID() const;

    /**
    Returns getUniqueID()
    Does not throw
    */
    operator string () const;

    /**
    Returns the module serial number
    Does not throw
    */
    string getModule() const;

    /**
    Returns the run number
    Does not throw
    */
    unsigned int getRunNumber() const;

    /**
    Returns the scan number
    Does not throw
    */
    unsigned int getScanNumber() const;

private:
    unsigned int runNumber;
    unsigned int scanNumber;
    string uniqueID;
    string module;    
};

}

#endif //SCTDATA_UNIQUEID_H
