#include "TrimRangeTestResult.h"
#include "DefaultVariable.h"
#include "mVThresholdVariable.h"

#include "Sct/SctParameters.h"
#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <boost/shared_ptr.hpp>

namespace SctData{
    
    string TrimRangeTestResult::getClassName() const throw(){
	return string("SctData::TrimRangeTestResult");
    }

    TrimRangeTestResult::TrimRangeTestResult() throw() : chipTrimData(nChipModule), chipTrim(nChipModule),
							 charge(0), type(0), algorithm(0) {}
    
    TrimRangeTestResult::TrimRangeTestResult(unsigned int runNumber, const string& moduleName) throw() 
	: TestResult(runNumber, moduleName, mVThresholdVariable::instance(), *DefaultVariable::instance(ST_TRIM)),
	chipTrimData(nChipModule), chipTrim(nChipModule), charge(0), type(0), algorithm(0) {}
    
    TrimRangeTestResult::~TrimRangeTestResult() throw() {}

  string TrimRangeTestResult::Trim::getClassName() const throw(){
    return string("SctData::TrimRangeTestResult::Trim");
  }
  
  string TrimRangeTestResult::TrimData::getClassName() const throw(){
    return string("SctData::TrimRangeTestResult::TrimData");
  }
  
  string TrimRangeTestResult::ChipTrim::getClassName() const throw(){
    return string("SctData::TrimRangeTestResult::ChipTrim");
  }
  
  string TrimRangeTestResult::ChipTrimData::getClassName() const throw(){
    return string("SctData::TrimRangeTestResult::ChipTrimData");
  }
    
    const Stats<double> TrimRangeTestResult::ChipTrimData::getOffsets() const throw() {
	Stats<double> offset(nChannelChip);
	offset.resize(nChannelChip);
	for (unsigned i=0; i<nChannelChip; ++i){
	    offset.modifyAt(i).valid = (channelData.getAt(i).valid && channelData.getAt(i).value.p1 != 0);
	    if (offset.getAt(i).valid) {
		offset.modifyAt(i).value=channelData.getAt(i).value.p0;
	    }
	}
	return offset;
    }
    
    const Stats<double> TrimRangeTestResult::ChipTrimData::getSteps() const throw() {
	Stats<double> step;
	step.resize(nChannelChip);
	for (unsigned i=0; i<nChannelChip; ++i){
	    step.modifyAt(i).valid = (channelData.getAt(i).valid && channelData.getAt(i).value.p1 != 0);
	    if (step.getAt(i).valid){
		step.modifyAt(i).value = 1./channelData.getAt(i).value.p1;
	    }
	}
	return step;
    }
    
}// end of namespace SctData
