#ifndef SCTDATA_STANDARDDEFECTS_H
#define SCTDATA_STANDARDDEFECTS_H


namespace SctData {
    
class DefectPrototype;

/**
  This is a holder class for all the DefectPrototype objects that are used
  @author Matthew Palmer
*/
class StandardDefects {
public:
    //@{ @name Fit Defects
    static const DefectPrototype DEAD;	        ///< Output always v small
    static const DefectPrototype STUCKON;	///< Output always v high
    static const DefectPrototype OVER; 	///< Occupancy larger than max
    static const DefectPrototype UNDER;	///< Occupancy never reaches mas
    static const DefectPrototype NOINIT;	///< Couldn't initialize the fit.
    static const DefectPrototype BADFIT;	///< The fit was not good for some reason - parameter is a chi2 cut
    //@}
    //@{ @name Strobe Delay Defects
    static const DefectPrototype SD_LO;	///< Low edge is not between 0 and 35
    static const DefectPrototype SD_HI;	///< Low edge is above 63
    //@}
    //@{ @name NPt Gain Defects
    static const DefectPrototype VLO_GAIN;   ///< Gain < 0.3 * chip average
    static const DefectPrototype LO_GAIN;   ///< Gain < 0.75 * chip average
    static const DefectPrototype HI_GAIN;    ///< Gain > 1.25 * chip average
    static const DefectPrototype LO_OFFSET; ///< Offset < -100
    static const DefectPrototype HI_OFFSET;  ///< Offset > 120
    static const DefectPrototype UNBONDED;     ///< Noise <= 750
    static const DefectPrototype PARTBONDED;   ///< Noise <= 1100
    static const DefectPrototype NOISY;   ///< Noise > 1.15* av chip noise
    static const DefectPrototype V_NOISY;   ///< Noise > 1.25* av chip noise
    //@}
    //@{ @name Trim Defects
    static const DefectPrototype TR_RANGE;      ///< Unexpected chip trim step size
    static const DefectPrototype TR_STEP;       ///< Channel step different from chip
    static const DefectPrototype TR_OFFSET;     ///< Channel offset different from chip
    static const DefectPrototype TR_NOTRIM;    ///< Untrimmable channel
    //@}
    //@{ Other defects
    static const DefectPrototype NO_HI;    /// high noise occupancy
    static const DefectPrototype MEAN_ERROR;
    static const DefectPrototype SIG_ERROR;
    static const DefectPrototype STUCK_CELL; ///< pipeline
    static const DefectPrototype DEAD_CELL; ///< pipeline
    static const DefectPrototype TOKEN;     ///< full bypass token
    static const DefectPrototype RTOKEN;    ///< full bypass token
    static const DefectPrototype TW_HI;     ///< time walk too big
    static const DefectPrototype TW_LO;     ///< time walk too small
    //@}
};
}
#endif //SCTDATA_STANDARDDEFECTS_H
