#bin/csh

if ( $# != 1 ) then
 echo Usage: $0 ClassName \\t eg $0 FitScanResult
 exit 1
endif

set tmpfile = `mktemp /tmp/StreamerUpdate.XXXXXX` || exit 1;
set tmpfile2 = `mktemp /tmp/StreamerUpdate.XXXXXX` || exit 1;

set list_cpp = `find -name $1"Streamer_v*.cpp" > $tmpfile`
echo list of matching cpp files :
cat $tmpfile

set existing_versions = `cat $tmpfile | sed s/$1Streamer_v// | sed s/.cpp// | sed 's/\.\///' > $tmpfile2 `
echo list of existing versions :
cat $tmpfile2

set version = `cat $tmpfile2 | sort -n | tail -1`

#echo largest existing version : $version
set old_cpp = {$1}Streamer_v${version}.cpp
set old_h = {$1}Streamer_v${version}.h

set new_version = `echo $version'  + 1 ' | bc -l`
#echo new version = $new_version
set new_cpp = {$1}Streamer_v${new_version}.cpp
set new_h = {$1}Streamer_v${new_version}.h

#echo checking existance of $old_cpp and $old_h

if ( { test -r $old_cpp } ) else 
  echo $old_cpp not readable or dosent exist 
  exit 1
endif
if ( { test -r $old_h } ) else
  echo $old_h not readable or dosent exist
  exit 1
endif

chmod -w $old_h
chmod -w $old_cpp

#echo checking non-existance of $new_cpp and $new_h

if ( { test -f $new_cpp } ) then 
  echo $new_cpp already exists - this should not happen - internal error in $0
  exit 1
endif
if ( { test -f $new_h } ) then
  echo $new_h already exists!
  exit 1
endif

echo "\n ->" makeing $new_cpp

cat $old_cpp | sed s/{$1}Streamer_v${version}/{$1}Streamer_v${new_version}/g | sed s/s_version=${version}/s_version=${new_version}/g > $new_cpp

if ( { grep s_version=${new_version} $new_cpp } ) else
  echo I can not find the line \ns_version=${new_version}\n in $new_cpp - this is very suspicious to me!
endif

echo  "\n ->" makeing $new_h

cat $old_h | sed s/{$1}Streamer_v${version}/{$1}Streamer_v${new_version}/g | sed s/STREAMER_H/STREAMER_V${new_version}_H/ > $new_h


echo \\n\\nyou should now do \\n
echo cvs add $new_cpp
echo cvs add $new_h

