#include "Sct/VersionNotSupportedException.h"
#include "Sct/IoExceptions.h"

#include "../TrimRangeTestResult.h"
#include "TrimRangeTestResultStreamer_v2.h"

#include <TF1.h>
#include <vector>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TrimRangeTestResultStreamer_v2::s_version=2;

TrimRangeTestResultStreamer_v2::TrimRangeTestResultStreamer_v2() throw() {
  // std::cout << "v2 ... " << getVersion() << endl;
}

bool TrimRangeTestResultStreamer_v2::inMap = IOManager::addToMap("SctData::TrimRangeTestResult",  auto_ptr<Streamer>(new TrimRangeTestResultStreamer_v2()));

shared_ptr<Streamable> TrimRangeTestResultStreamer_v2::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new TrimRangeTestResult());
    read(in, *ad, manager);
    return ad;
}

void TrimRangeTestResultStreamer_v2::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //cout << "TrimRangeTestResultIS::publishGuts" << endl;
    //Let superclass do its work

    manager.writeImpl(out, ob, "SctData::TestResult");

    const TrimRangeTestResult& mytest = dynamic_cast <const TrimRangeTestResult&>(ob);

    out << (int) mytest.chipTrimData.size();
    for (unsigned int i = 0; i < mytest.chipTrimData.size(); ++i) {
        manager.writeImpl(out, *mytest.chipTrimData[i], false);
    }

    out << (int) mytest.chipTrim.size();
    for (unsigned int i = 0; i < mytest.chipTrim.size(); ++i) {
        manager.writeImpl(out, *mytest.chipTrim[i], false);
    }

    out << mytest.charge << mytest.type << mytest.algorithm;
}

void TrimRangeTestResultStreamer_v2::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    TrimRangeTestResult& mytest = dynamic_cast < TrimRangeTestResult & >(ob);

    int n = 0;
    in >> n;
    mytest.chipTrimData.resize(n);
    for (int i = 0; i<n; ++i) {
	mytest.chipTrimData[i] = shared_ptr<TrimRangeTestResult::ChipTrimData>(new TrimRangeTestResult::ChipTrimData() );
        manager.readImpl(in, const_cast<TrimRangeTestResult::ChipTrimData&>(*mytest.chipTrimData[i]), false);
    }

    in >> n;
    mytest.chipTrim.resize(n);
    for (int i = 0; i<n; ++i) {
	mytest.chipTrim[i] = shared_ptr<TrimRangeTestResult::ChipTrim>(new TrimRangeTestResult::ChipTrim() );
        manager.readImpl(in, const_cast<TrimRangeTestResult::ChipTrim&>(*mytest.chipTrim[i]), false);
    }

    in >> mytest.charge >> mytest.type >> mytest.algorithm;
}


}
} 

