#include "Sct/OutOfRangeError.h"
#include "TGraphAsymmErrorsStreamer_v1.h"

#include "../RootStreamableAdapter.h"

///@todo Change back once fixed
#include "../TGraphAsymmErrorsFix.h"
#include <TClass.h>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned TGraphAsymmErrorsStreamer_v1::s_version=1;
	
TGraphAsymmErrorsStreamer_v1::TGraphAsymmErrorsStreamer_v1() throw() {}
bool TGraphAsymmErrorsStreamer_v1::inMap = IOManager::addToMap(TGraphAsymmErrors::Class()->GetName(),  auto_ptr<Streamer>(new TGraphAsymmErrorsStreamer_v1()));

void TGraphAsymmErrorsStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ///@todo sort this out - unscalable casts needed for RootStreamableAdapter
    manager.writeImpl(out, ob, "TGraph");
    const RootStreamableAdapter& ad = dynamic_cast<const RootStreamableAdapter&>(ob);
    TGraphAsymmErrors* g = dynamic_cast<TGraphAsymmErrors*>(ad.getObject());

    double* error = g->GetEXhigh();
    out.put(error, g->GetN());
    error = g->GetEXlow();
    out.put(error, g->GetN());

    error = g->GetEYhigh();
    out.put(error, g->GetN());
    error = g->GetEYlow();
    out.put(error, g->GetN());
}

void TGraphAsymmErrorsStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    ///@todo sort this out - unscalable casts needed for RootStreamableAdapter
    manager.readImpl(in, ob, "TGraph");
    RootStreamableAdapter& ad = dynamic_cast<RootStreamableAdapter&>(ob);
    TGraphAsymmErrors* g = dynamic_cast<TGraphAsymmErrors*>(ad.getObject());

    double* exl=0, *exh=0, *eyl=0, *eyh=0;
    size_t size = 0;
    in.get(&exh, size);
    if ((int) size != g->GetN())
        throw OutOfRangeError<int>("TGraphAsymmErrors A", __FILE__, __LINE__ ,size, g->GetN(), g->GetN());

    in.get(&exl, size);
    if ((int) size != g->GetN())
        throw OutOfRangeError<int>("TGraphAsymmErrors B", __FILE__, __LINE__ ,size, g->GetN(), g->GetN());

    in.get(&eyh, size);
    if ((int) size != g->GetN())
        throw OutOfRangeError<int>("TGraphAsymmErrors C", __FILE__, __LINE__ ,size, g->GetN(), g->GetN());

    in.get(&eyl, size);
    if ((int) size != g->GetN())
        throw OutOfRangeError<int>("TGraphAsymmErrors D", __FILE__, __LINE__ ,size, g->GetN(), g->GetN());

    for (int i=0; i<g->GetN(); ++i) {
        g->SetPointError(i, exl[i], exh[i], eyl[i], eyh[i]);
    }

    delete [] exl;
    delete [] exh;
    delete [] eyl;
    delete [] eyh;
}


shared_ptr<Streamable> TGraphAsymmErrorsStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new RootStreamableAdapter(*new TGraphAsymmErrorsFix()));

    read(in, *ad, manager);
    return ad;
}
}

}

