#include "ScanResultStreamer_v1.h"
#include "../ScanResult.h"
#include "Sct/VersionNotSupportedException.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"

#include <string>

using namespace std;
using namespace Sct;

namespace SctData {
namespace IO {
/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned ScanResultStreamer_v1::s_version=1;

bool ScanResultStreamer_v1::inMap = IOManager::addToMap("SctData::ScanResult",  std::auto_ptr<Streamer>(new ScanResultStreamer_v1()));

ScanResultStreamer_v1::ScanResultStreamer_v1() throw() {}

shared_ptr<Streamable> ScanResultStreamer_v1::read(IStream&, IOManager const&) const throw(LogicError, IoError) {
	    throw LogicError("Cannot make a ScanResult - abstract class",__FILE__,__LINE__);
}

void ScanResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Downcast should always work!
    const ScanResult& raw = dynamic_cast<const ScanResult&>(ob);
    manager.writeImpl(out, raw.getHeader(), false);
    manager.writeImpl(out, raw.getPoints(), false);
    manager.writeImpl(out, raw.getConfiguration(), false);
}

void ScanResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Downcast should always work!
    ScanResult& raw = dynamic_cast<ScanResult&>(ob);
    //Now read everthing else in.
    manager.readImpl(in, raw.getHeader(), false);
    //cout << "Done header" << endl;
    manager.readImpl(in, raw.getPoints(), false);
    //cout << "Done ScanPoints" << endl;
    manager.readImpl(in, raw.getConfiguration(), false);
    //cout << "Done all "<<endl;
}
}
}
