#include "PipelineTestResultStreamer_v1.h"
#include "../PipelineTestResult.h"

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned PipelineTestResultStreamer_v1::s_version=1;

PipelineTestResultStreamer_v1::PipelineTestResultStreamer_v1() throw() {}

bool PipelineTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::PipelineTestResult",  auto_ptr<Streamer>(new PipelineTestResultStreamer_v1()));

shared_ptr<Streamable> PipelineTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError){
    shared_ptr<Streamable> ad (new PipelineTestResult());
    read(in, *ad, manager);
    return ad;
}

void PipelineTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");
}

void PipelineTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");
}

} 
}
