#include "../NoiseOccupancyTestResult.h"
#include "../RootStreamableAdapter.h"
#include "NoiseOccupancyTestResultStreamer_v1.h"

#include <TGraph.h>
#include <TF1.h>

using namespace Sct;

namespace SctData {
namespace IO {

/* READ NOTES ON STREAMERS AND VERSIONS BEFORE EDITING THIS FILE! */
unsigned NoiseOccupancyTestResultStreamer_v1::s_version=1;
	
NoiseOccupancyTestResultStreamer_v1::NoiseOccupancyTestResultStreamer_v1() throw() {}

bool NoiseOccupancyTestResultStreamer_v1::inMap = IOManager::addToMap("SctData::NoiseOccupancyTestResult",  auto_ptr<Streamer>(new NoiseOccupancyTestResultStreamer_v1()));

shared_ptr<Streamable> NoiseOccupancyTestResultStreamer_v1::read(IStream& in, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ad (new NoiseOccupancyTestResult());
    read(in, *ad, manager);
    return ad;
}

void NoiseOccupancyTestResultStreamer_v1::write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    //Let superclass do its work
    manager.writeImpl(out, ob, "SctData::TestResult");

    const NoiseOccupancyTestResult& mytest = dynamic_cast<const NoiseOccupancyTestResult&>(ob);
    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
        writeChipResult(out, mytest.getChipResult(ichip), manager);
    }
}

void NoiseOccupancyTestResultStreamer_v1::read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError) {
    manager.readImpl(in, ob, "SctData::TestResult");

    NoiseOccupancyTestResult& mytest = dynamic_cast<NoiseOccupancyTestResult&>(ob);
    for (unsigned int ichip=0; ichip<nChipModule; ichip++) {
        readChipResult(in, mytest.getChipResult(ichip), manager);
    }
}

void NoiseOccupancyTestResultStreamer_v1::writeChipResult(OStream& out, const ChipNOResult& c, const IOManager& manager) const throw (LogicError, IoError) {
    manager.writeImpl(out, RootStreamableAdapter( *c.graph ), true);
    manager.writeImpl(out, RootStreamableAdapter( *c.fit ), false);
    out << c.mean << c.rms << c.offset;
}

void NoiseOccupancyTestResultStreamer_v1::readChipResult(IStream& in, ChipNOResult& c, const IOManager& manager) const throw(LogicError, IoError) {
    shared_ptr<Streamable> ob = manager.readImpl(in);
    shared_ptr<RootStreamableAdapter> ad  = boost::dynamic_pointer_cast<RootStreamableAdapter>(ob);
    c.graph = shared_ptr<TGraph> ( dynamic_cast<TGraph*>(ad->getObject()));
    
    auto_ptr<TF1> f = NoiseOccupancyTestResult::createFitFunction();
    RootStreamableAdapter ad2( *f.release() );
    manager.readImpl(in, ad2, false);
    c.fit = shared_ptr<TF1> ( dynamic_cast<TF1*>(ad2.getObject()) );
    in >> c.mean >> c.rms >> c.offset;
}

}
}
